/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.inspector;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.TableItem;
import org.gvt.ChisioMain;
import org.gvt.inspector.Inspector;
import org.gvt.model.EdgeModel;
import org.patika.mada.graph.GraphObject;

public class EdgeInspector
extends Inspector {
    private EdgeInspector(org.gvt.model.GraphObject model, String title, ChisioMain main) {
        super(model, title, main);
    }

    private void prepare() {
        TableItem item = this.addRow(this.table, "Text");
        item.setText(1, this.model.getText());
        item = this.addRow(this.table, "Text Font");
        Font font = this.model.getTextFont();
        String fontName = font.getFontData()[0].getName();
        int fontSize = font.getFontData()[0].getHeight();
        int fontStyle = font.getFontData()[0].getStyle();
        if (fontSize > 14) {
            fontSize = 14;
        }
        item.setText(1, fontName);
        item.setFont(1, new Font(null, fontName, fontSize, fontStyle));
        item.setForeground(1, this.model.getTextColor());
        item = this.addRow(this.table, "Color");
        item.setBackground(1, this.model.getColor());
        item = this.addRow(this.table, "Style");
        item.setText(1, ((EdgeModel)this.model).getStyle());
        item = this.addRow(this.table, "Arrow");
        item.setText(1, ((EdgeModel)this.model).getArrow());
        item = this.addRow(this.table, "Width");
        item.setText(1, "" + ((EdgeModel)this.model).getWidth());
    }

    private void show() {
        this.createContents(this.shell);
        this.shell.setLocation(this.calculateInspectorLocation(this.main.clickLocation.x, this.main.clickLocation.y));
        this.shell.open();
    }

    private void prepareForGraphObject() {
        GraphObject go = (GraphObject)((Object)this.model);
        for (String[] property : go.getInspectable()) {
            this.addRow(this.table, property[0]).setText(1, property[1]);
        }
        this.table.getColumn(1).pack();
        this.table.pack();
    }

    public static void getInstance(org.gvt.model.GraphObject model, String title, ChisioMain main) {
        if (EdgeInspector.isSingle(model)) {
            EdgeInspector ins = new EdgeInspector(model, title, main);
            instances.add(ins);
            ins.prepare();
            if (model instanceof GraphObject) {
                ins.prepareForGraphObject();
            }
            ins.show();
        }
    }
}

