/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.gvt.LayoutManager;
import org.gvt.model.EClusterManager;
import org.gvt.model.EdgeBendpoint;
import org.gvt.model.EdgeIterator;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeIterator;
import org.gvt.model.NodeModel;
import org.ivis.layout.Cluster;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;

public class CompoundModel
extends NodeModel {
    private boolean isRoot = false;
    private boolean isDirected = false;
    protected List<NodeModel> children;
    int labelHeight;
    private EClusterManager eClusterManager;
    public static Dimension DEFAULT_SIZE = new Dimension(40, 40);
    public static String DEFAULT_TEXT = "Compound";
    public static Font DEFAULT_TEXT_FONT = new Font(null, new FontData("Arial", 8, 0));
    public static Color DEFAULT_TEXT_COLOR = ColorConstants.white;
    public static Color DEFAULT_COLOR = new Color(null, 177, 83, 112);
    public static Color DEFAULT_BORDER_COLOR = new Color(null, 177, 83, 112);
    public static int MARGIN_SIZE = 10;
    public static int LABEL_HEIGHT = 20;
    public static int DEFAULT_CLUSTER_ID = 0;
    public static final int ALL_EDGES = 0;
    public static final int INTRA_GRAPH_EDGES = 1;
    public static final int INTER_GRAPH_EDGES = 2;
    public static final String P_CHILDREN = "_children";

    public CompoundModel() {
        this(new Rectangle(new Point(0, 0), DEFAULT_SIZE));
    }

    public CompoundModel(Point pt) {
        this(new Rectangle(pt, DEFAULT_SIZE));
    }

    public CompoundModel(Rectangle rect) {
        this.setConstraint(rect);
        this.text = DEFAULT_TEXT;
        this.textFont = DEFAULT_TEXT_FONT;
        this.textColor = DEFAULT_TEXT_COLOR;
        this.color = DEFAULT_COLOR;
        this.borderColor = DEFAULT_BORDER_COLOR;
        this.shape = DEFAULT_SHAPE;
        this.children = new ArrayList<NodeModel>();
        this.labelHeight = LABEL_HEIGHT;
    }

    public CompoundModel(Point pt, Color c, String lbl) {
        this(new Rectangle(pt, DEFAULT_SIZE));
        this.setColor(c);
        this.setText(lbl);
    }

    public int getLabelHeight() {
        return this.labelHeight;
    }

    public void setLabelHeight(int labelHeight) {
        this.labelHeight = labelHeight;
    }

    public EClusterManager getClusterManager() {
        return this.eClusterManager;
    }

    public void setClusterManager(EClusterManager eClusterManager) {
        this.eClusterManager = eClusterManager;
    }

    @Override
    public void update(LGraphObject lGraphObj) {
        this.calculateSizeUp();
        if (this.isRoot()) {
            LayoutManager.getInstance().animate();
        } else {
            LNode lNode = (LNode)lGraphObj;
            if (lNode.getChild() == null || lNode.getChild().getNodes().size() == 0) {
                this.setLocationAbs(new Point(lNode.getRect().x, lNode.getRect().y));
            }
        }
    }

    public void addChild(NodeModel node) {
        this.children.add(node);
        this.firePropertyChange(P_CHILDREN, -1, node);
    }

    public List getChildren() {
        return this.children;
    }

    public void removeChild(Object o) {
        if (o instanceof NodeModel) {
            NodeModel nodeModel = (NodeModel)o;
            nodeModel.resetClusters();
        }
        this.children.remove(o);
        this.firePropertyChange(P_CHILDREN, o, null);
    }

    @Override
    public void setParentModel(CompoundModel parent) {
        super.setParentModel(parent);
        if (parent != null) {
            this.setClusterManager(parent.getClusterManager());
        }
    }

    public void calculateSizeDown() {
        for (NodeModel child : this.children) {
            if (!(child instanceof CompoundModel)) continue;
            ((CompoundModel)child).calculateSizeDown();
        }
        if (this.getParentModel() != null && !this.isRoot) {
            if (this.children.size() == 0) {
                this.setSize(DEFAULT_SIZE);
            } else {
                Rectangle bound = this.calculateBounds();
                Dimension diff = this.getLocationAbs().getDifference(bound.getLocation());
                this.setLocationAbs(new Point(bound.x - MARGIN_SIZE, bound.y - MARGIN_SIZE));
                this.setSize(new Dimension(bound.width + 2 * MARGIN_SIZE, bound.height + 2 * MARGIN_SIZE + this.labelHeight));
                for (NodeModel child : this.children) {
                    child.setLocationAbs(child.getLocationAbs().translate(diff.width + MARGIN_SIZE, diff.height + MARGIN_SIZE));
                }
            }
        }
    }

    public void calculateSizeUp() {
        if (this.getParentModel() != null && !this.isRoot) {
            if (this.children.size() == 0) {
                this.setSize(DEFAULT_SIZE);
            } else {
                Rectangle bound = this.calculateBounds();
                Dimension diff = this.getLocationAbs().getDifference(bound.getLocation());
                this.setLocationAbs(new Point(bound.x - MARGIN_SIZE, bound.y - MARGIN_SIZE));
                this.setSize(new Dimension(bound.width + 2 * MARGIN_SIZE, bound.height + 2 * MARGIN_SIZE + this.labelHeight));
                for (NodeModel child : this.children) {
                    child.setLocationAbs(child.getLocationAbs().translate(diff.width + MARGIN_SIZE, diff.height + MARGIN_SIZE));
                }
            }
            this.getParentModel().calculateSizeUp();
        }
        this.updatePolygonsOfChildren();
    }

    public void setMarginSize(int margin) {
        MARGIN_SIZE = margin;
        CompoundModel root = this;
        while (root.getParentModel() != null) {
            root = root.getParentModel();
        }
        for (Object o : root.getChildren()) {
            if (!(o instanceof CompoundModel)) continue;
            this.updateMarginSize((CompoundModel)o);
        }
    }

    private void updateMarginSize(CompoundModel root) {
        for (Object o : root.getChildren()) {
            GraphObject child = (GraphObject)o;
            if (!(child instanceof CompoundModel)) continue;
            this.updateMarginSize((CompoundModel)child);
        }
        root.calculateSizeUp();
    }

    public Iterator getEdgeIterator(int edgeType, boolean isRecursive, boolean onlyEndsWithinRoot) {
        return new EdgeIterator(this, edgeType, isRecursive, onlyEndsWithinRoot);
    }

    public void setAsRoot() {
        this.isRoot = true;
        if (this.eClusterManager == null) {
            this.eClusterManager = new EClusterManager();
        }
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean directed) {
        this.isDirected = directed;
    }

    public Set getEdges() {
        return ((EdgeIterator)this.getEdgeIterator(0, true, false)).getEdges();
    }

    public Set getNodes() {
        return ((NodeIterator)this.getNodeIterator(true)).getNodes();
    }

    public Iterator getNodeIterator(boolean isRecursive) {
        return new NodeIterator(this, isRecursive);
    }

    public boolean isAncestorofNode(NodeModel node) {
        for (CompoundModel root = node.getParentModel(); root != null; root = root.getParentModel()) {
            if (root != this) continue;
            return true;
        }
        return false;
    }

    public Rectangle calculateBounds() {
        int top = Integer.MAX_VALUE;
        int left = Integer.MAX_VALUE;
        int right = 0;
        int bottom = 0;
        for (NodeModel node : this.getChildren()) {
            Point locAbs = node.getLocationAbs();
            Dimension size = node.getSize();
            int nodeTop = locAbs.y;
            int nodeLeft = locAbs.x;
            int nodeRight = locAbs.x + size.width;
            int nodeBottom = locAbs.y + size.height;
            if (top > nodeTop) {
                top = nodeTop;
            }
            if (left > nodeLeft) {
                left = nodeLeft;
            }
            if (right < nodeRight) {
                right = nodeRight;
            }
            if (bottom >= nodeBottom) continue;
            bottom = nodeBottom;
        }
        Iterator itr = this.isRoot ? this.getEdges().iterator() : this.getEdgeIterator(0, true, true);
        while (itr.hasNext()) {
            EdgeModel edge = (EdgeModel)itr.next();
            edge.updateBendpoints();
            for (int i = 0; i < edge.bendpoints.size(); ++i) {
                EdgeBendpoint eb = (EdgeBendpoint)edge.bendpoints.get(i);
                Point loc = eb.getLocationFromModel(edge);
                int x = loc.x;
                int y = loc.y;
                if (top > y) {
                    top = y;
                }
                if (left > x) {
                    left = x;
                }
                if (right < x) {
                    right = x;
                }
                if (bottom >= y) continue;
                bottom = y;
            }
        }
        if ((double)top == Double.MAX_VALUE) {
            return null;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    @Override
    public void addCluster(int clusterID) {
        super.addCluster(clusterID);
        Cluster cluster = this.eClusterManager.getClusterByID(clusterID);
        List<NodeModel> childrenNodes = this.children;
        for (NodeModel childModel : childrenNodes) {
            childModel.addCluster(cluster);
        }
    }

    @Override
    public void addCluster(Cluster cluster) {
        super.addCluster(cluster);
        List<NodeModel> childrenNodes = this.children;
        for (NodeModel childModel : childrenNodes) {
            childModel.addCluster(cluster);
        }
    }

    @Override
    public void removeCluster(Cluster cluster) {
        super.removeCluster(cluster);
        List<NodeModel> childrenNodes = this.children;
        for (NodeModel childModel : childrenNodes) {
            childModel.removeCluster(cluster);
        }
    }

    @Override
    public void resetClusters() {
        ArrayList clusters = new ArrayList();
        clusters.addAll(this.clusters);
        super.resetClusters();
        List<NodeModel> childrenNodes = this.children;
        for (NodeModel childModel : childrenNodes) {
            for (Cluster cluster : clusters) {
                childModel.removeCluster(cluster);
            }
        }
    }

    @Override
    protected void updatePolygonsOfChildren() {
        super.updatePolygonsOfChildren();
        for (NodeModel childModel : this.children) {
            childModel.updatePolygonsOfChildren();
        }
    }
}

