/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.gvt.model.EdgeBendpoint;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.util.Conf;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Updatable;
import org.ivis.util.DimensionD;
import org.ivis.util.PointD;

public class EdgeModel
extends GraphObject
implements Updatable {
    private NodeModel sourceNode;
    private NodeModel targetNode;
    protected String style;
    protected String arrow;
    protected int width;
    protected List bendpoints;
    public static String DEFAULT_TEXT = "";
    public static Font DEFAULT_TEXT_FONT = new Font(null, new FontData("Arial", 8, 0));
    public static Color DEFAULT_TEXT_COLOR = ColorConstants.black;
    public static Color DEFAULT_COLOR = ColorConstants.black;
    public static String DEFAULT_ARROW = "None";
    public static String DEFAULT_STYLE = "Solid";
    public static int DEFAULT_WIDTH = 1;
    public static final String P_STYLE = "_style";
    public static final String P_ARROW = "_arrow";
    public static final String P_WIDTH = "_width";
    public static final String P_BENDPOINT = "_bendpoint";

    public EdgeModel() {
        this.text = DEFAULT_TEXT;
        this.textFont = DEFAULT_TEXT_FONT;
        this.textColor = DEFAULT_TEXT_COLOR;
        this.color = DEFAULT_COLOR;
        this.style = DEFAULT_STYLE;
        this.arrow = DEFAULT_ARROW;
        this.width = DEFAULT_WIDTH;
        this.bendpoints = new ArrayList();
    }

    @Override
    public void update(LGraphObject lGraphObj) {
        if (!Conf.getBoolean("SPREAD_DOUBLE_EDGES")) {
            return;
        }
        LEdge lEdge = (LEdge)lGraphObj;
        ArrayList<EdgeBendpoint> bendpoints = new ArrayList<EdgeBendpoint>();
        for (PointD p : lEdge.getBendpoints()) {
            PointD sourceLoc = new PointD(lEdge.getSource().getCenterX(), lEdge.getSource().getCenterY());
            PointD targetLoc = new PointD(lEdge.getTarget().getCenterX(), lEdge.getTarget().getCenterY());
            if (p.getX() == p.getY()) {
                double difX = sourceLoc.getX() - targetLoc.getX();
                double difY = sourceLoc.getY() - targetLoc.getY();
                double lengthSq = difX * difX + difY * difY;
                double xShare = difX * difX / lengthSq;
                double yShare = 1.0 - xShare;
                double xx = Math.sqrt(lengthSq / 300.0 * yShare) * Math.signum(difY);
                double yy = Math.sqrt(lengthSq / 300.0 * xShare) * Math.signum(difX);
                int index = (int)p.getX();
                if (index < 0) {
                    xx *= -1.0;
                    yy *= -1.0;
                    index *= -1;
                }
                if (index % 2 == 1) {
                    xx *= -1.0;
                    yy *= -1.0;
                }
                double centerX = (sourceLoc.getX() + targetLoc.getX()) / 2.0;
                double centerY = (sourceLoc.getY() + targetLoc.getY()) / 2.0;
                p.setX(centerX - (xx *= (double)(index / 2 + 1)));
                p.setY(centerY + (yy *= (double)(index / 2 + 1)));
            }
            DimensionD dim1 = p.getDifference(sourceLoc);
            DimensionD dim2 = p.getDifference(targetLoc);
            EdgeBendpoint ebp = new EdgeBendpoint();
            ebp.setRelativeDimensions(new Dimension((int)dim1.width, (int)dim1.height), new Dimension((int)dim2.width, (int)dim2.height));
            bendpoints.add(ebp);
        }
        this.setBendpoints(bendpoints);
    }

    private PointD getClippingPoint(LNode node, PointD towards) {
        PointD center = node.getCenter();
        double halfH = node.getHeight() / 2.0;
        double halfW = node.getWidth() / 2.0;
        double xDif = towards.getX() - center.getX();
        double yDif = towards.getY() - center.getY();
        if (xDif == 0.0) {
            return new PointD(center.getX(), center.getY() < towards.getY() ? center.getY() + halfH : center.getY() - halfH);
        }
        double rat = yDif / xDif;
        if (halfW * Math.abs(rat) <= halfH) {
            double xx = towards.getX() > center.getX() ? center.getX() + halfW : center.getX() - halfW;
            double yy = halfW * Math.abs(rat);
            if (towards.getY() - center.getY() < 0.0) {
                yy = -yy;
            }
            return new PointD(xx, center.getY() + yy);
        }
        double yy = towards.getY() > center.getY() ? center.getY() + halfH : center.getY() - halfH;
        double xx = halfH / Math.abs(rat);
        if (towards.getX() - center.getX() < 0.0) {
            xx = -xx;
        }
        return new PointD(center.getX() + xx, yy);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String s) {
        this.style = s;
        this.firePropertyChange(P_STYLE, null, this.style);
    }

    public String getArrow() {
        return this.arrow;
    }

    public void setArrow(String a) {
        this.arrow = a;
        this.firePropertyChange(P_ARROW, null, this.arrow);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
        this.firePropertyChange(P_WIDTH, null, this.width);
    }

    public NodeModel getSource() {
        return this.sourceNode;
    }

    public void setSource(NodeModel source) {
        this.sourceNode = source;
    }

    public NodeModel getTarget() {
        return this.targetNode;
    }

    public void setTarget(NodeModel target) {
        this.targetNode = target;
    }

    public void detachSource() {
        this.sourceNode.removeSourceConnection(this);
    }

    public void detachTarget() {
        this.targetNode.removeTargetConnection(this);
    }

    public void attachSource() {
        if (!this.sourceNode.getSourceConnections().contains(this)) {
            this.sourceNode.addSourceConnection(this);
        }
    }

    public void attachTarget() {
        if (!this.targetNode.getTargetConnections().contains(this)) {
            this.targetNode.addTargetConnection(this);
        }
    }

    public boolean isIntragraph() {
        return this.getSource().getParentModel() == this.getTarget().getParentModel();
    }

    public List getBendpoints() {
        return this.bendpoints;
    }

    public void insertBendpoint(int index, Bendpoint point) {
        this.getBendpoints().add(index, point);
        this.firePropertyChange(P_BENDPOINT, null, null);
    }

    public void insertBendpoint(Bendpoint point) {
        this.getBendpoints().add(point);
        this.firePropertyChange(P_BENDPOINT, null, null);
    }

    public void removeBendpoint(int index) {
        this.getBendpoints().remove(index);
        this.firePropertyChange(P_BENDPOINT, null, null);
    }

    public void setBendpoint(int index, Bendpoint point) {
        this.getBendpoints().set(index, point);
        this.firePropertyChange(P_BENDPOINT, null, null);
    }

    public void setBendpoints(List points) {
        this.bendpoints = points;
        this.firePropertyChange(P_BENDPOINT, null, null);
    }

    public void removeAllBendpoints() {
        this.bendpoints.clear();
        this.firePropertyChange(P_BENDPOINT, null, null);
    }

    public void updateBendpoints() {
        this.firePropertyChange(P_BENDPOINT, null, null);
    }
}

