/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.basicsif;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.biopax.paxtools.model.level3.Level3Element;
import org.cbio.causality.idmapping.HGNC;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.patika.mada.util.XRef;

public class BasicSIFNode
extends BioPAXNode {
    private String rdfid;
    private static final Color SM_COLOR = new Color(null, 255, 255, 255);

    public BasicSIFNode(CompoundModel root, String rdfid, String name) {
        super(root);
        this.rdfid = rdfid;
        if (name == null) {
            name = rdfid;
        }
        this.setText(name);
        this.addReference(new XRef("name:" + name));
        this.setShape("RoundRect");
        this.configFromModel();
        int width = Math.max(this.suggestInitialWidth(), 40);
        int height = 20;
        this.setSize(new Dimension(width, height));
    }

    public BasicSIFNode(BioPAXNode excised, CompoundModel root) {
        super(excised, root);
        this.rdfid = ((BasicSIFNode)excised).getRdfid();
    }

    @Override
    public void configFromModel() {
        this.setTooltipText(this.getText());
        String symbol = HGNC.getSymbol(this.getText());
        if (symbol != null) {
            this.setColor(this.getStringSpecificColor(this.getText()));
            this.addReference(new XRef("HGNC SYMBOL", symbol));
        } else {
            this.setColor(SM_COLOR);
        }
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return new ArrayList();
    }

    public String getRdfid() {
        return this.rdfid;
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        list.add(new String[]{"ID", this.rdfid});
        return list;
    }
}

