/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.evidence;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.Actor;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.Complex;
import org.gvt.model.biopaxl2.Control;
import org.gvt.model.biopaxl2.Conversion;
import org.gvt.model.biopaxl2.Hub;
import org.gvt.model.biopaxl2.PEPBasedEdge;
import org.gvt.util.ID;

public class NonModulatedEffector
extends PEPBasedEdge {
    private control cont;
    private interaction controlled;
    private int sign;

    public NonModulatedEffector(NodeModel source, NodeModel target, control cont, physicalEntityParticipant pep, interaction controlled) {
        super(source, target, pep);
        assert (source instanceof Actor || source instanceof Complex);
        assert (target instanceof Conversion || target instanceof Control || target instanceof Hub);
        this.cont = cont;
        this.controlled = controlled;
        this.sign = Control.isActivation(cont) ? 1 : -1;
        this.setColor(this.isPositive() ? Control.EDGE_COLOR_ACTIVATE : Control.EDGE_COLOR_INHIBIT);
        this.setArrow(cont instanceof catalysis ? "Catalysis" : (cont.getCONTROL_TYPE() == null ? "Modulation" : (this.isPositive() ? "Stimulation" : "Inhibition")));
    }

    public NonModulatedEffector(NonModulatedEffector excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.cont = excised.getControl();
        this.controlled = excised.getControlled();
        this.sign = excised.getSign();
    }

    public control getControl() {
        return this.cont;
    }

    public interaction getControlled() {
        return this.controlled;
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    @Override
    public String getIDHash() {
        return super.getIDHash() + ID.get(this.cont);
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        BioPAXNode.addNamesAndTypeAndID(list, this.cont);
        for (evidence ev : this.cont.getEVIDENCE()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.cont.getINTERACTION_TYPE().isEmpty()) {
            String s = BioPAXNode.formatInString(this.cont.getINTERACTION_TYPE());
            list.add(new String[]{"Interaction Type", s});
        }
        if (this.cont.getCONTROL_TYPE() != null) {
            list.add(new String[]{"Control Type", this.cont.getCONTROL_TYPE().toString()});
        }
        BioPAXNode.addDataSourceAndXrefAndComments(list, this.cont);
        return list;
    }
}

