/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXCompoundNode;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.ChbComplex;
import org.gvt.model.biopaxl3.ChbControl;
import org.gvt.model.biopaxl3.ChbConversion;
import org.gvt.model.biopaxl3.ChbPathway;
import org.gvt.model.biopaxl3.ChbTempReac;
import org.gvt.model.biopaxl3.Compartment;
import org.gvt.model.biopaxl3.ComplexMember;
import org.gvt.model.biopaxl3.EffectorFirstHalf;
import org.gvt.model.biopaxl3.EffectorSecondHalf;
import org.gvt.model.biopaxl3.Hub;
import org.gvt.model.biopaxl3.Member;
import org.gvt.model.biopaxl3.MultiTouch;
import org.gvt.model.biopaxl3.NonModulatedEffector;
import org.gvt.model.biopaxl3.Pairing;
import org.gvt.model.biopaxl3.Product;
import org.gvt.model.biopaxl3.Substrate;
import org.gvt.model.biopaxl3.Template;
import org.gvt.util.BioPAXL3Converter;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.gvt.util.PathwayHolder;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Representable;

public class BioPAXL3Graph
extends BioPAXGraph {
    private Pathway pathway;
    private Map<Interaction, Collection<GraphObject>> interactionMap;

    public BioPAXL3Graph(Model model) {
        this.graphType = "PROCESS_DIAGRAM";
        this.biopaxModel = model;
        this.setAsRoot();
    }

    public BioPAXL3Graph(Model biopaxModel, Pathway pathway2) {
        this(biopaxModel);
        this.pathway = pathway2;
        if (pathway2 == null) {
            this.pathway = BioPAXUtil.createGlobalPathway((Model)biopaxModel, (String)"Entire content").l3p;
        }
        BioPAXL3Converter converter = new BioPAXL3Converter(this);
        converter.convert();
    }

    public BioPAXL3Graph(Model model, Collection<String> pathwayMemberIDs, String pathwayName) {
        this(model);
        this.pathway = BioPAXUtil.createPathway((Model)model, (String)(pathwayName == null ? "unnamed pathway" : pathwayName), pathwayMemberIDs).l3p;
        BioPAXL3Converter converter = new BioPAXL3Converter(this);
        converter.convert();
    }

    @Override
    public PathwayHolder getPathway() {
        if (this.pathway == null) {
            return null;
        }
        return new PathwayHolder(this.pathway);
    }

    @Override
    public void setPathway(PathwayHolder pathway2) {
        this.pathway = pathway2.l3p;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.pathway != null) {
            this.pathway.setDisplayName(name);
        }
    }

    public Map<Interaction, Collection<GraphObject>> getInteractionMap() {
        if (this.interactionMap == null) {
            this.prepareInteractionMap();
        }
        return this.interactionMap;
    }

    private void prepareInteractionMap() {
        this.interactionMap = new HashMap<Interaction, Collection<GraphObject>>();
        for (Object o : this.getNodes()) {
            Node node = (Node)o;
            Interaction inter = null;
            if (node instanceof ChbConversion) {
                inter = ((ChbConversion)node).getConversion();
            } else if (node instanceof ChbControl) {
                inter = ((ChbControl)node).getControl();
            } else if (node instanceof ChbTempReac) {
                inter = ((ChbTempReac)node).getTemplateReaction();
            } else if (node instanceof Hub) {
                inter = ((Hub)node).getInteraction();
            }
            if (inter == null) continue;
            if (!this.interactionMap.containsKey(inter)) {
                this.interactionMap.put(inter, new ArrayList());
            }
            this.interactionMap.get(inter).add(node);
        }
        for (Object o : this.getEdges()) {
            Interaction inter = null;
            if (o instanceof NonModulatedEffector) {
                inter = ((NonModulatedEffector)o).getControl();
            } else if (o instanceof Pairing) {
                inter = ((Pairing)o).getInteraction();
            }
            if (inter == null) continue;
            if (!this.interactionMap.containsKey(inter)) {
                this.interactionMap.put(inter, new ArrayList());
            }
            this.interactionMap.get(inter).add((GraphObject)o);
        }
    }

    @Override
    protected void prepareEntityToNodeMap() {
        this.entityToNodeMap = new HashMap();
        for (Object o : this.getNodes()) {
            Node node = (Node)o;
            if (node instanceof Actor) {
                this.getRelatedNodeList(((Actor)node).getEntity()).add(node);
                continue;
            }
            if (!(node instanceof ChbComplex)) continue;
            this.getRelatedNodeList(((ChbComplex)node).getEntity()).add(node);
        }
    }

    private List<Node> getRelatedNodeList(EntityHolder he) {
        if (!this.entityToNodeMap.containsKey(he)) {
            this.entityToNodeMap.put(he, new ArrayList());
        }
        return (List)this.entityToNodeMap.get(he);
    }

    @Override
    public boolean fetchLayout() {
        assert (this.pathway != null);
        return this.fetchLayout(ID.get(this.pathway));
    }

    @Override
    public boolean fetchLayout(String pathwayRDFID) {
        assert (this.biopaxModel != null);
        boolean allLayedOut = true;
        for (Object o : this.getNodes()) {
            NodeModel node;
            if (o instanceof BioPAXNode) {
                node = (BioPAXNode)o;
                allLayedOut = ((BioPAXNode)node).fetchLocation(pathwayRDFID) && allLayedOut;
                continue;
            }
            if (!(o instanceof BioPAXCompoundNode) || !((BioPAXCompoundNode)o).getChildren().isEmpty()) continue;
            node = (BioPAXCompoundNode)o;
            allLayedOut = ((BioPAXCompoundNode)node).fetchLocation(pathwayRDFID) && allLayedOut;
        }
        for (Object o : this.getNodes()) {
            if (!(o instanceof CompoundModel)) continue;
            ((CompoundModel)o).calculateSizeUp();
        }
        return allLayedOut;
    }

    @Override
    public void recordLayout() {
        assert (this.biopaxModel != null);
        assert (this.pathway != null);
        for (Object o : this.getNodes()) {
            NodeModel node;
            if (o instanceof BioPAXNode) {
                node = (BioPAXNode)o;
                ((BioPAXNode)node).recordLocation();
                continue;
            }
            if (!(o instanceof BioPAXCompoundNode) || !((BioPAXCompoundNode)o).getChildren().isEmpty()) continue;
            node = (BioPAXCompoundNode)o;
            ((BioPAXCompoundNode)node).recordLocation();
        }
    }

    @Override
    public void forgetLayout() {
        assert (this.biopaxModel != null);
        assert (this.pathway != null);
        for (Object o : this.getNodes()) {
            NodeModel node;
            if (o instanceof BioPAXNode) {
                node = (BioPAXNode)o;
                ((BioPAXNode)node).eraseLocation();
                continue;
            }
            if (!(o instanceof BioPAXCompoundNode) || !((BioPAXCompoundNode)o).getChildren().isEmpty()) continue;
            node = (BioPAXCompoundNode)o;
            ((BioPAXCompoundNode)node).eraseLocation();
        }
    }

    @Override
    public void registerContentsToPathway() {
        assert (this.pathway != null);
        assert (this.pathway.getPathwayComponent().isEmpty()) : "Pathway already constains something";
        for (Object o : this.getNodes()) {
            if (o instanceof ChbConversion) {
                this.pathway.addPathwayComponent(((ChbConversion)o).getConversion());
                continue;
            }
            if (o instanceof ChbControl) {
                this.pathway.addPathwayComponent(((ChbControl)o).getControl());
                continue;
            }
            if (o instanceof ChbTempReac) {
                this.pathway.addPathwayComponent(((ChbTempReac)o).getTemplateReaction());
                continue;
            }
            if (!(o instanceof Hub)) continue;
            this.pathway.addPathwayComponent(((Hub)o).getInteraction());
        }
        for (Object o : this.getEdges()) {
            if (o instanceof Pairing) {
                this.pathway.addPathwayComponent(((Pairing)o).getInteraction());
            }
            if (!(o instanceof NonModulatedEffector)) continue;
            this.pathway.addPathwayComponent(((NonModulatedEffector)o).getControl());
        }
    }

    @Override
    public String getPathwayRDFID() {
        if (this.pathway != null) {
            return ID.get(this.pathway);
        }
        return null;
    }

    @Override
    public BioPAXGraph excise(Collection<GraphObject> objects, boolean keepHighlights) {
        BioPAXL3Graph exGraph = new BioPAXL3Graph(this.getBiopaxModel());
        HashSet<GraphObject> toExcise = new HashSet<GraphObject>(objects);
        HashSet<GraphObject> newObjs = new HashSet<GraphObject>(toExcise);
        HashSet<GraphObject> processInTurn = new HashSet<GraphObject>();
        HashSet<String> compartmentsToExcise = new HashSet<String>();
        do {
            processInTurn.clear();
            processInTurn.addAll(newObjs);
            newObjs.clear();
            for (GraphObject go : new ArrayList(processInTurn)) {
                Set<GraphObject> reqs = go.getRequisites();
                Iterator<GraphObject> iterator = reqs.iterator();
                while (iterator.hasNext()) {
                    GraphObject req = iterator.next();
                    if (toExcise.contains(req)) continue;
                    newObjs.add(req);
                    toExcise.add(req);
                    if (!(req instanceof Compartment)) continue;
                    compartmentsToExcise.add(((Compartment)req).getName());
                }
            }
        } while (!newObjs.isEmpty());
        HashMap<NodeModel, NodeModel> map = new HashMap<NodeModel, NodeModel>();
        map.put(this, exGraph);
        HashSet<Node> toProcess = new HashSet<Node>();
        for (GraphObject graphObject : toExcise) {
            if (!(graphObject instanceof Node)) continue;
            toProcess.add((Node)graphObject);
        }
        while (!toProcess.isEmpty()) {
            HashSet<Node> unfinished = new HashSet<Node>();
            for (Node node : toProcess) {
                CompoundModel compound = ((NodeModel)((Object)node)).getParentModel();
                if (map.containsKey(compound)) {
                    NodeModel orig;
                    CompoundModel newRoot = (CompoundModel)map.get(compound);
                    if (node instanceof Compartment) {
                        orig = (Compartment)node;
                        map.put(orig, new Compartment((Compartment)orig, newRoot));
                    } else if (node instanceof ChbComplex) {
                        orig = (ChbComplex)node;
                        map.put(orig, new ChbComplex((ChbComplex)orig, newRoot));
                    } else if (node instanceof ComplexMember) {
                        orig = (ComplexMember)node;
                        map.put(orig, new ComplexMember((ComplexMember)orig, (ChbComplex)newRoot));
                    } else if (node instanceof Actor) {
                        orig = (Actor)node;
                        map.put(orig, new Actor((Actor)orig, newRoot));
                    } else if (node instanceof ChbConversion) {
                        orig = (ChbConversion)node;
                        map.put(orig, new ChbConversion((ChbConversion)orig, newRoot));
                    } else if (node instanceof ChbTempReac) {
                        orig = (ChbTempReac)node;
                        map.put(orig, new ChbTempReac((ChbTempReac)orig, newRoot));
                    } else if (node instanceof ChbControl) {
                        orig = (ChbControl)node;
                        map.put(orig, new ChbControl((ChbControl)orig, newRoot));
                    } else if (node instanceof Hub) {
                        orig = (Hub)node;
                        map.put(orig, new Hub((Hub)orig, newRoot));
                    } else if (node instanceof ChbPathway) {
                        orig = (ChbPathway)node;
                        map.put(orig, new ChbPathway((ChbPathway)orig, newRoot));
                    } else {
                        System.err.println("Missing: " + node);
                    }
                    if (!keepHighlights) continue;
                    ((NodeModel)map.get(node)).setHighlight(node.isHighlighted());
                    continue;
                }
                if (compound instanceof Compartment && !compartmentsToExcise.contains(((Compartment)compound).getName())) {
                    Compartment orig = (Compartment)node;
                    map.put(orig, new Compartment(orig, (CompoundModel)exGraph));
                    if (!keepHighlights) continue;
                    ((NodeModel)map.get(node)).setHighlight(node.isHighlighted());
                    continue;
                }
                unfinished.add(node);
            }
            toProcess = unfinished;
        }
        for (GraphObject graphObject : toExcise) {
            if (graphObject instanceof BioPAXEdge) {
                BioPAXEdge edge = (BioPAXEdge)graphObject;
                assert (map.containsKey(edge.getSource())) : "No source. s: " + edge.getSource() + " t: " + edge.getTarget();
                assert (map.containsKey(edge.getTarget())) : "No target. s: " + edge.getSource() + " t: " + edge.getTarget();
            }
            BioPAXEdge exEdge = null;
            if (graphObject instanceof Substrate) {
                exEdge = new Substrate((Substrate)graphObject, map);
            } else if (graphObject instanceof Template) {
                exEdge = new Template((Template)graphObject, map);
            } else if (graphObject instanceof Product) {
                exEdge = new Product((Product)graphObject, map);
            } else if (graphObject instanceof NonModulatedEffector) {
                exEdge = new NonModulatedEffector((NonModulatedEffector)graphObject, map);
            } else if (graphObject instanceof EffectorFirstHalf) {
                exEdge = new EffectorFirstHalf((EffectorFirstHalf)graphObject, map);
            } else if (graphObject instanceof EffectorSecondHalf) {
                exEdge = new EffectorSecondHalf((EffectorSecondHalf)graphObject, map);
            } else if (graphObject instanceof Pairing) {
                exEdge = new Pairing((Pairing)graphObject, map);
            } else if (graphObject instanceof MultiTouch) {
                exEdge = new MultiTouch((MultiTouch)graphObject, map);
            } else if (graphObject instanceof Member) {
                exEdge = new Member((Member)graphObject, map);
            }
            if (!keepHighlights || exEdge == null) continue;
            exEdge.setHighlight(graphObject.isHighlighted());
        }
        exGraph.setGraphType("PROCESS_DIAGRAM");
        return exGraph;
    }

    @Override
    public BioPAXGraph excise(PathwayHolder p) {
        Map<Interaction, Collection<GraphObject>> intMap = this.getInteractionMap();
        HashSet<GraphObject> set = new HashSet<GraphObject>();
        for (Interaction inter : this.getMemberInteractions(p.l3p, null)) {
            Collection<GraphObject> graphObjects = intMap.get(inter);
            if (graphObjects == null) continue;
            for (GraphObject graphObject : graphObjects) {
                if (graphObject == null) continue;
                set.add(graphObject);
            }
        }
        Graph excised = this.excise(set);
        ((BioPAXGraph)excised).setName(p.getName());
        ((BioPAXGraph)excised).setPathway(p);
        return excised;
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (this.pathway != null) {
            BioPAXNode.addNamesAndTypeAndID(list, this.pathway);
            BioPAXNode.addDataSourceAndXrefAndComments(list, this.pathway);
        }
        return list;
    }

    private Set<Interaction> getMemberInteractions(Pathway p, Set<Pathway> pset) {
        HashSet<Interaction> set = new HashSet<Interaction>();
        if (pset == null) {
            pset = new HashSet<Pathway>();
        }
        for (Process comp : p.getPathwayComponent()) {
            if (comp instanceof Interaction) {
                set.add((Interaction)comp);
                continue;
            }
            if (!(comp instanceof Pathway)) continue;
            if (comp == p) {
                System.err.println("Pathway includes itself: " + p.getDisplayName());
                continue;
            }
            if (pset.contains(comp)) {
                System.err.println("Pathway has cyclic reference: " + p.getDisplayName());
                continue;
            }
            pset.add((Pathway)comp);
            set.addAll(this.getMemberInteractions((Pathway)comp, pset));
        }
        return set;
    }

    @Override
    public Set<Node> getRelatedStates(EntityHolder pe) {
        HashSet<Node> states = new HashSet<Node>();
        for (Object o : this.getNodes()) {
            ChbComplex com;
            if (o instanceof Actor) {
                Actor act = (Actor)o;
                if (!act.getEntity().equals(pe)) continue;
                states.add(act);
                continue;
            }
            if (!(o instanceof ChbComplex) || !(com = (ChbComplex)o).getEntity().equals(pe)) continue;
            states.add(com);
        }
        return states;
    }

    @Override
    public Set<Node> getRelatedStates(Collection<EntityHolder> entities) {
        HashSet<Node> states = new HashSet<Node>();
        for (Object o : this.getNodes()) {
            ChbComplex com;
            if (o instanceof Actor) {
                Actor act = (Actor)o;
                if (!entities.contains(act.getEntity())) continue;
                states.add(act);
                continue;
            }
            if (!(o instanceof ChbComplex) || !entities.contains((com = (ChbComplex)o).getEntity())) continue;
            states.add(com);
        }
        return states;
    }

    @Override
    public void replaceComplexMembersWithComplexes(Collection<Node> objects) {
        for (GraphObject graphObject : new HashSet<Node>(objects)) {
            if (!(graphObject instanceof ComplexMember)) continue;
            objects.remove(graphObject);
            ChbComplex cmp = ((ComplexMember)graphObject).getParentComplex();
            if (objects.contains(cmp)) continue;
            objects.add(cmp);
        }
    }

    @Override
    public void representDataOnActors(String type) {
        if (type == null) {
            return;
        }
        for (Object nm : this.getNodes()) {
            if (!(nm instanceof BioPAXNode)) continue;
            BioPAXNode node = (BioPAXNode)nm;
            Representable data = node.getRepresentableData(type);
            boolean isProt = false;
            if (node instanceof Actor) {
                Actor a = (Actor)node;
                EntityHolder holder = a.getEntity();
                isProt = holder.getNamed().getClass().toString().contains("Protein");
            }
            if (data == null) {
                if (isProt) {
                    node.setColor(noDataC_Protein);
                } else {
                    node.setColor(noDataC);
                }
                node.setTooltipText("No Data");
                node.setTextColor(Actor.DEFAULT_TEXT_COLOR);
                continue;
            }
            if (data.alterNodeColor()) {
                node.setColor(data.getNodeColor());
            }
            if (data.alterTextColor()) {
                node.setTextColor(data.getTextColor());
            }
            if (!data.alterToolTipText()) continue;
            node.setTooltipText(data.getToolTipText());
        }
    }

    @Override
    public void removeRepresentations() {
        for (Object nm : this.getNodes()) {
            if (!(nm instanceof BioPAXNode)) continue;
            BioPAXNode node = (BioPAXNode)nm;
            node.configFromModel();
        }
    }
}

