/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.Compartment;
import org.gvt.model.biopaxl3.ComplexMember;
import org.gvt.model.biopaxl3.Product;
import org.gvt.model.biopaxl3.Substrate;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Ranker;

public class ChbConversion
extends BioPAXNode {
    private Conversion conv;
    private boolean direction;
    private boolean t;
    private Set<Node> tabu;
    private static final Color COLOR = new Color(null, 170, 170, 170);
    public static final boolean LEFT_TO_RIGHT = true;
    public static final boolean RIGHT_TO_LEFT = false;

    public ChbConversion(CompoundModel root) {
        super(root);
        this.setColor(COLOR);
        this.setText("");
        this.setSize(new Dimension(12, 12));
        this.setShape("Rectangle");
    }

    public ChbConversion(CompoundModel root, Conversion conv, boolean direction, NodeProvider prov) {
        this(root);
        this.conv = conv;
        this.direction = direction;
        this.configFromModel();
        prov.register(ID.get(conv), this);
        this.buildConnections(root, conv, direction, prov);
    }

    public ChbConversion(ChbConversion excised, CompoundModel root) {
        super(excised, root);
        this.conv = excised.getConversion();
        this.direction = excised.getDirection();
        this.configFromModel();
    }

    @Override
    public void configFromModel() {
        this.extractReferences(this.conv);
        this.setTooltipText(this.conv.getDisplayName());
        if (this.util.hasModelTag("DEPLETING_REACTION")) {
            this.setText("d");
        }
        if (this.util.hasModelTag("TRANSCRIPTION_TAG")) {
            this.t = true;
        }
    }

    public boolean isT() {
        return this.t;
    }

    public Conversion getConversion() {
        return this.conv;
    }

    public boolean getDirection() {
        return this.direction;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Arrays.asList(this.conv);
    }

    private void buildConnections(CompoundModel root, Conversion conv, boolean direction, NodeProvider prov) {
        Set<PhysicalEntity> subsSet = direction ? conv.getLeft() : conv.getRight();
        Set<PhysicalEntity> prodSet = !direction ? conv.getLeft() : conv.getRight();
        for (PhysicalEntity ent : subsSet) {
            NodeModel sub = prov.getNode(ID.get(ent), root);
            new Substrate(sub, this);
            if (!(sub instanceof Actor) || !((Actor)sub).isUbique()) continue;
            ((Actor)sub).setRelated(conv);
        }
        for (PhysicalEntity par : prodSet) {
            NodeModel prod = prov.getNode(ID.get(par), root);
            new Product(this, prod);
            if (!(prod instanceof Actor) || !((Actor)prod).isUbique()) continue;
            ((Actor)prod).setRelated(conv);
        }
        if (!this.t && subsSet.isEmpty() && prodSet.size() == 1) {
            this.t = true;
            this.setText("t");
            this.util.recordModelTag("TRANSCRIPTION_TAG", "");
        }
        this.createControlOverInteraction(root, conv, prov);
    }

    public static String getPossibleCompartmentName(Conversion conv) {
        HashSet<String> names = new HashSet<String>();
        for (PhysicalEntity ent : conv.getLeft()) {
            ChbConversion.getCompartmentName(names, ent);
        }
        for (PhysicalEntity ent : conv.getRight()) {
            ChbConversion.getCompartmentName(names, ent);
        }
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return null;
    }

    private static void getCompartmentName(Set<String> names, PhysicalEntity ent) {
        if (ent.getCellularLocation() != null && !ent.getCellularLocation().getTerm().isEmpty()) {
            names.add(ent.getCellularLocation().getTerm().iterator().next());
        }
    }

    public static List<String> getPossibleCompartmentNames(Conversion conv) {
        ArrayList<String> names = new ArrayList<String>();
        for (PhysicalEntity ent : conv.getLeft()) {
            if (ent.getCellularLocation() == null) continue;
            names.add(ent.getCellularLocation().getTerm().iterator().next());
        }
        for (PhysicalEntity ent : conv.getRight()) {
            if (ent.getCellularLocation() == null) continue;
            names.add(ent.getCellularLocation().getTerm().iterator().next());
        }
        return names;
    }

    public void selectBestCompartment() {
        CompoundModel comp;
        List<NodeModel> neighbors = this.getNeighborsList();
        Ranker<CompoundModel> r = new Ranker<CompoundModel>();
        for (NodeModel neigh : neighbors) {
            CompoundModel cm;
            if (neigh instanceof ComplexMember) {
                neigh = neigh.getParentModel();
            }
            if ((cm = neigh.getParentModel()) == null) continue;
            r.count(cm);
        }
        List list = r.getRankedList();
        if (list.isEmpty()) {
            return;
        }
        List firstGroup = list.get(0);
        if (firstGroup.size() == 1) {
            comp = (CompoundModel)firstGroup.get(0);
        } else {
            for (NodeModel neigh : neighbors) {
                CompoundModel cm;
                if (neigh instanceof ComplexMember) {
                    neigh = neigh.getParentModel();
                }
                if ((cm = neigh.getParentModel()) != null) {
                    cm = cm.getParentModel();
                }
                if (cm == null) continue;
                r.count(cm);
            }
            list = r.getRankedList();
            List secondGroup = list.get(0);
            assert (!secondGroup.isEmpty());
            if (secondGroup.size() == 1) {
                comp = (CompoundModel)secondGroup.get(0);
            } else {
                ArrayList copySec = new ArrayList(secondGroup);
                copySec.retainAll(firstGroup);
                if (!copySec.isEmpty()) {
                    secondGroup = copySec;
                }
                if (!((comp = (CompoundModel)secondGroup.get(0)) instanceof Compartment) && secondGroup.size() > 1) {
                    comp = (CompoundModel)secondGroup.get(1);
                }
            }
        }
        this.getParentModel().removeChild(this);
        comp.addChild(this);
        this.setParentModel(comp);
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public boolean isTranscriptionEvent() {
        return this.isT();
    }

    @Override
    public Set<Node> getTabuNodes() {
        if (this.tabu == null) {
            this.tabu = new HashSet<Node>();
            for (Edge edge : this.getUpstream()) {
                if (!(edge instanceof Substrate)) continue;
                this.tabu.add(edge.getSourceNode());
            }
        }
        return new HashSet<Node>(this.tabu);
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        Boolean bl;
        List<String[]> list = super.getInspectable();
        ChbConversion.addNamesAndTypeAndID(list, this.conv);
        HashSet<String> evidences = new HashSet<String>();
        for (Evidence evidence2 : this.conv.getEvidence()) {
            Set<EvidenceCodeVocabulary> codes = evidence2.getEvidenceCode();
            for (EvidenceCodeVocabulary code : codes) {
                for (String term : code.getTerm()) {
                    if (term.isEmpty()) continue;
                    evidences.add(term);
                }
            }
        }
        ArrayList evList = new ArrayList(evidences);
        Collections.sort(evList);
        for (String evid : evList) {
            list.add(new String[]{"Evidence", evid});
        }
        if (!this.conv.getInteractionType().isEmpty()) {
            String string = ChbConversion.formatInString(this.conv.getInteractionType());
            list.add(new String[]{"Interaction Type", string});
        }
        if ((bl = this.conv.getSpontaneous()) != null) {
            list.add(new String[]{"Spontaneous", bl.toString()});
        }
        ChbConversion.addDataSourceAndXrefAndComments(list, this.conv);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.conv) + this.direction;
    }

    public boolean isDepleting() {
        return this.util.hasModelTag("DEPLETING_REACTION");
    }
}

