/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Process;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.ChbComplex;
import org.gvt.model.biopaxl3.ChbControl;
import org.gvt.model.biopaxl3.ChbConversion;
import org.gvt.model.biopaxl3.ChbPathway;
import org.gvt.model.biopaxl3.ChbTempReac;
import org.gvt.model.biopaxl3.Hub;
import org.gvt.util.ID;

public class NonModulatedEffector
extends BioPAXEdge {
    private Control cont;
    private Process controlled;
    private int sign;

    public NonModulatedEffector(NodeModel source, NodeModel target, Control cont, Process controlled) {
        super(source, target);
        assert (source instanceof Actor || source instanceof ChbComplex || source instanceof ChbPathway);
        assert (target instanceof ChbConversion || target instanceof ChbTempReac || target instanceof ChbControl || target instanceof Hub);
        this.cont = cont;
        this.controlled = controlled;
        this.sign = ChbControl.isActivation(cont) ? 1 : -1;
        this.setColor(this.isPositive() ? ChbControl.EDGE_COLOR_ACTIVATE : ChbControl.EDGE_COLOR_INHIBIT);
        this.setArrow(cont instanceof Catalysis ? "Catalysis" : (cont.getControlType() == null ? "Modulation" : (this.isPositive() ? "Stimulation" : "Inhibition")));
    }

    public NonModulatedEffector(NonModulatedEffector excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.cont = excised.getControl();
        this.controlled = excised.getControlled();
        this.sign = excised.getSign();
    }

    public Control getControl() {
        return this.cont;
    }

    public Process getControlled() {
        return this.controlled;
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    @Override
    public String getIDHash() {
        return super.getIDHash() + ID.get(this.cont);
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        BioPAXNode.addNamesAndTypeAndID(list, this.cont);
        for (Evidence ev : this.cont.getEvidence()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.cont.getInteractionType().isEmpty()) {
            String s = BioPAXNode.formatInString(this.cont.getInteractionType());
            list.add(new String[]{"Interaction Type", s});
        }
        if (this.cont.getControlType() != null) {
            list.add(new String[]{"Control Type", this.cont.getControlType().toString()});
        }
        BioPAXNode.addDataSourceAndXrefAndComments(list, this.cont);
        return list;
    }
}

