/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class AnimatedGIF {
    public static void configure(IIOMetadata meta, String delayTime, int imageIndex) {
        Node child;
        String metaFormat = meta.getNativeMetadataFormatName();
        if (!"javax_imageio_gif_image_1.0".equals(metaFormat)) {
            throw new IllegalArgumentException("Unfamiliar gif metadata format: " + metaFormat);
        }
        Node root = meta.getAsTree(metaFormat);
        for (child = root.getFirstChild(); child != null && !"GraphicControlExtension".equals(child.getNodeName()); child = child.getNextSibling()) {
        }
        IIOMetadataNode gce = (IIOMetadataNode)child;
        gce.setAttribute("userDelay", "FALSE");
        gce.setAttribute("delayTime", delayTime);
        if (imageIndex == 0) {
            IIOMetadataNode aes = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode ae = new IIOMetadataNode("ApplicationExtension");
            ae.setAttribute("applicationID", "NETSCAPE");
            ae.setAttribute("authenticationCode", "2.0");
            byte[] uo = new byte[]{1, 0, 0};
            ae.setUserObject(uo);
            aes.appendChild(ae);
            root.appendChild(aes);
        }
        try {
            meta.setFromTree(metaFormat, root);
        }
        catch (IIOInvalidTreeException e) {
            throw new Error(e);
        }
    }

    public static void saveAnimate(File file, BufferedImage[] frames, String[] delayTimes) throws Exception {
        ImageWriter iw = ImageIO.getImageWritersByFormatName("gif").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(file);
        iw.setOutput(ios);
        iw.prepareWriteSequence(null);
        for (int i = 0; i < frames.length; ++i) {
            BufferedImage src = frames[i];
            ImageWriteParam iwp = iw.getDefaultWriteParam();
            IIOMetadata metadata = iw.getDefaultImageMetadata(new ImageTypeSpecifier(src), iwp);
            AnimatedGIF.configure(metadata, delayTimes[i], i);
            IIOImage ii = new IIOImage(src, null, metadata);
            iw.writeToSequence(ii, null);
        }
        iw.endWriteSequence();
        ios.close();
    }

    public static void printUsage() {
        StringBuffer sb = new StringBuffer();
        String eol = System.getProperty("line.separator");
        sb.append("Usage: 2 forms each using 3 arguments");
        sb.append(eol);
        sb.append("1) output (animated GIF) file name");
        sb.append(eol);
        sb.append("2) input files (animation frames), separated by ','");
        sb.append(eol);
        sb.append("3) single frame rate, or comma separared list of frame rates");
        sb.append(eol);
        sb.append("java WriteAnimatedGif animate.gif frm1.gif,frm2.gif,..,frmN.gif 100");
        sb.append(eol);
        sb.append("java WriteAnimatedGif animate.gif frm1.gif,frm2.gif,..,frmN.gif 100,40,..,N");
        sb.append(eol);
        sb.append("The 2nd form must have exactly as many integers as there are frames.");
        sb.append(eol);
        sb.append("Frame rates are specified in increments of 1/100th second, NOT milliseconds.");
        sb.append(eol);
        System.err.print(sb);
    }

    public static String checkDelay(String delay) {
        try {
            int val = Integer.parseInt(delay);
            if (val < 1) {
                System.err.println("Animation frame delay '" + val + "' is < 1!");
                AnimatedGIF.printUsage();
                System.exit(1);
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("Could not parse '" + delay + "' as an integer.");
            AnimatedGIF.printUsage();
            System.exit(1);
        }
        return delay;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            AnimatedGIF.printUsage();
            System.exit(1);
        }
        File f = new File(args[0]);
        String[] names = args[1].split(",");
        if (names.length < 2) {
            System.err.println("An animation requires 2 or more frames!");
            AnimatedGIF.printUsage();
            System.exit(1);
        }
        BufferedImage[] frames = new BufferedImage[names.length];
        for (int ii = 0; ii < names.length; ++ii) {
            frames[ii] = ImageIO.read(new File(names[ii]));
        }
        String[] delays = args[2].split(",");
        String[] delayTimes = new String[names.length];
        if (delays.length == 1) {
            for (int ii = 0; ii < delayTimes.length; ++ii) {
                delayTimes[ii] = AnimatedGIF.checkDelay(delays[0]);
            }
        } else if (delays.length != names.length) {
            System.err.println(delays.length + " delays specified for " + names.length + " frames!");
            AnimatedGIF.printUsage();
            System.exit(1);
        } else {
            for (int ii = 0; ii < delayTimes.length; ++ii) {
                delayTimes[ii] = AnimatedGIF.checkDelay(delays[ii]);
            }
        }
        AnimatedGIF.saveAnimate(f, frames, delayTimes);
    }

    public static void generate(String[] pngFiles, String outGIF, int delay) throws Exception {
        BufferedImage[] frames = new BufferedImage[pngFiles.length];
        for (int i = 0; i < pngFiles.length; ++i) {
            frames[i] = ImageIO.read(new File(pngFiles[i]));
        }
        String[] delays = new String[frames.length];
        for (int i = 0; i < delays.length; ++i) {
            delays[i] = "" + delay;
        }
        AnimatedGIF.saveAnimate(new File(outGIF), frames, delays);
    }
}

