/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cise;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Iterator;
import java.util.Set;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.cise.CiSELayout;
import org.ivis.layout.cise.CiSEOnCircleNodeExt;
import org.ivis.layout.fd.FDLayoutNode;
import org.ivis.util.IMath;

public class CiSENode
extends FDLayoutNode {
    public double rotationAmount;
    private CiSEOnCircleNodeExt onCircleNodeExt = null;

    public CiSENode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    public CiSENode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        super(gm, loc, size, vNode);
    }

    public double getLimitedDisplacement(double displacement) {
        if (Math.abs(displacement) > 300.0) {
            displacement = 300.0 * (double)IMath.sign(displacement);
        }
        return displacement;
    }

    public CiSEOnCircleNodeExt getOnCircleNodeExt() {
        return this.onCircleNodeExt;
    }

    public Set<CiSENode> getOnCircleNeighbors() {
        Set neighbors = this.getNeighborsList();
        Iterator neighborIterator = neighbors.iterator();
        while (neighborIterator.hasNext()) {
            CiSENode neighbor = (CiSENode)neighborIterator.next();
            if (neighbor.getOnCircleNodeExt() != null && neighbor.getClusterID().equals(this.getClusterID())) continue;
            neighborIterator.remove();
        }
        return neighbors;
    }

    public CiSEOnCircleNodeExt setAsOnCircleNode() {
        assert (this.onCircleNodeExt == null);
        this.onCircleNodeExt = new CiSEOnCircleNodeExt(this);
        return this.onCircleNodeExt;
    }

    public void setAsNonOnCircleNode() {
        assert (this.onCircleNodeExt != null);
        this.onCircleNodeExt = null;
    }

    @Override
    public void move() {
        CiSELayout layout = (CiSELayout)this.getOwner().getGraphManager().getLayout();
        this.displacementX = this.getLimitedDisplacement(this.displacementX);
        this.displacementY = this.getLimitedDisplacement(this.displacementY);
        if (this.getChild() != null) {
            int noOfNodesOnCircle = this.getChild().getNodes().size();
            this.displacementX /= (double)noOfNodesOnCircle;
            this.displacementY /= (double)noOfNodesOnCircle;
            assert (noOfNodesOnCircle >= 2);
            for (CiSENode node : this.getChild().getNodes()) {
                node.moveBy(this.displacementX, this.displacementY);
                layout.totalDisplacement += Math.abs(this.displacementX) + Math.abs(this.displacementY);
            }
        }
        this.moveBy(this.displacementX, this.displacementY);
        layout.totalDisplacement += Math.abs(this.displacementX) + Math.abs(this.displacementY);
        if (this.getChild() != null) {
            this.getChild().updateBounds(true);
        }
        this.displacementX = 0.0;
        this.displacementY = 0.0;
    }
}

