/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.util.alignment;

import java.io.IOException;
import java.io.Reader;
import org.ivis.util.alignment.IncompatibleScoringSchemeException;
import org.ivis.util.alignment.InvalidSequenceException;
import org.ivis.util.alignment.PairwiseAlignment;
import org.ivis.util.alignment.ScoringScheme;

public abstract class PairwiseAlignmentAlgorithm {
    protected static final char MATCH_TAG = '|';
    protected static final char APPROXIMATE_MATCH_TAG = '+';
    protected static final char MISMATCH_TAG = ' ';
    protected static final char GAP_TAG = ' ';
    protected static final char GAP_CHARACTER = '-';
    protected boolean use_match_tag;
    protected ScoringScheme scoring;
    protected PairwiseAlignment alignment;
    protected int score;
    protected boolean score_computed = false;
    protected boolean sequences_loaded = false;

    public void setScoringScheme(ScoringScheme scoring) {
        if (scoring == null) {
            throw new IllegalArgumentException("Null scoring scheme object.");
        }
        this.scoring = scoring;
        this.use_match_tag = !scoring.isPartialMatchSupported();
        this.alignment = null;
        this.score_computed = false;
    }

    protected boolean useMatchTag() {
        return this.use_match_tag;
    }

    public void loadSequences(Reader input1, Reader input2) throws IOException, InvalidSequenceException {
        this.alignment = null;
        this.score_computed = false;
        this.sequences_loaded = false;
        this.loadSequencesInternal(input1, input2);
        this.sequences_loaded = true;
    }

    public void unloadSequences() {
        this.alignment = null;
        this.score_computed = false;
        this.unloadSequencesInternal();
        this.sequences_loaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PairwiseAlignment getPairwiseAlignment() throws IncompatibleScoringSchemeException {
        if (!this.sequences_loaded) {
            throw new IllegalStateException("Sequences have not been loaded.");
        }
        if (this.scoring == null) {
            throw new IllegalStateException("Scoring scheme has not been set.");
        }
        if (this.alignment == null) {
            ScoringScheme scoringScheme = this.scoring;
            synchronized (scoringScheme) {
                this.alignment = this.computePairwiseAlignment();
            }
            this.score = this.alignment.getScore();
            this.score_computed = true;
        }
        return this.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScore() throws IncompatibleScoringSchemeException {
        if (!this.sequences_loaded) {
            throw new IllegalStateException("Sequences have not been loaded.");
        }
        if (this.scoring == null) {
            throw new IllegalStateException("Scoring scheme has not been set.");
        }
        if (!this.score_computed) {
            ScoringScheme scoringScheme = this.scoring;
            synchronized (scoringScheme) {
                this.score = this.computeScore();
            }
            this.score_computed = true;
        }
        return this.score;
    }

    protected abstract void loadSequencesInternal(Reader var1, Reader var2) throws IOException, InvalidSequenceException;

    protected abstract void unloadSequencesInternal();

    protected abstract PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException;

    protected abstract int computeScore() throws IncompatibleScoringSchemeException;

    protected final int scoreSubstitution(char a, char b) throws IncompatibleScoringSchemeException {
        return this.scoring.scoreSubstitution(a, b);
    }

    protected final int scoreInsertion(char a) throws IncompatibleScoringSchemeException {
        return this.scoring.scoreInsertion(a);
    }

    protected final int scoreDeletion(char a) throws IncompatibleScoringSchemeException {
        return this.scoring.scoreDeletion(a);
    }

    protected final int max(int v1, int v2) {
        return v1 >= v2 ? v1 : v2;
    }

    protected final int max(int v1, int v2, int v3) {
        return v1 >= v2 ? (v1 >= v3 ? v1 : v3) : (v2 >= v3 ? v2 : v3);
    }

    protected final int max(int v1, int v2, int v3, int v4) {
        int m1 = v1 >= v2 ? v1 : v2;
        int m2 = v3 >= v4 ? v3 : v4;
        return m1 >= m2 ? m1 : m2;
    }
}

