/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;

public class MarkDistances {
    private Graph graph;
    private int limit;
    public static final String DIST_TO = "DIST_TO";
    public static final String DIST_FROM = "DIST_FROM";
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    public static final String VISITED = "VISITED";
    public static final String VISITED_WO_CH = "VISITED_WO_CH";
    public static final String VISITED_WO_PR = "VISITED_WO_PR";
    public static final String TEMP_DIST = "TEMP_DIST";
    public static final Integer PARENT_LOCK = 13;
    public static final Integer CHILD_LOCK = 14;

    public MarkDistances(Graph graph, int limit) {
        this.graph = graph;
        this.limit = limit;
    }

    public void run() {
        for (Node node : this.graph.getNodes()) {
            if (!node.hasSignificantExperimentalChange("Expression Data")) continue;
            this.labelBFS(node, true);
            this.clearStepLabels();
            this.labelBFS(node, false);
            this.clearStepLabels();
        }
    }

    private void labelBFS(Node root, boolean direction) {
        this.putDistance(root, root, direction, 0);
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(root);
        while (!queue.isEmpty()) {
            this.bfsStep(queue, root, direction);
        }
    }

    private void bfsStep(LinkedList<Node> queue, Node root, boolean direction) {
        int d;
        Node node = queue.poll();
        assert (!this.isVisited(node) || node.hasLabel(VISITED_WO_CH) || node.hasLabel(VISITED_WO_PR));
        int n = d = !this.isVisited(node) ? this.getDistance(node, root, direction) : ((Integer)node.getLabel(TEMP_DIST)).intValue();
        if (!(node.hasLabel(PARENT_LOCK) || this.isVisited(node) && !node.hasLabel(VISITED_WO_PR))) {
            for (Node node2 : node.getParents()) {
                if (this.isVisited(node2) && !node2.hasLabel(VISITED_WO_PR)) continue;
                if (queue.contains(node2)) {
                    queue.remove(node2);
                }
                queue.addFirst(node2);
                if (!this.isVisited(node2)) {
                    node2.putLabel(CHILD_LOCK);
                    this.putDistance(node2, root, direction, d);
                    continue;
                }
                node2.putLabel(TEMP_DIST, d);
            }
        }
        if (!(node.hasLabel(CHILD_LOCK) || this.isVisited(node) && !node.hasLabel(VISITED_WO_CH))) {
            for (Node node3 : node.getChildren()) {
                if (this.isVisited(node3) && !node3.hasLabel(VISITED_WO_CH)) continue;
                if (queue.contains(node3)) {
                    queue.remove(node3);
                }
                queue.addFirst(node3);
                if (!this.isVisited(node3)) {
                    this.putDistance(node3, root, direction, d);
                    node3.putLabel(PARENT_LOCK);
                    continue;
                }
                node3.putLabel(TEMP_DIST, d);
            }
        }
        if (d < this.limit && !this.isVisited(node)) {
            for (Edge edge : this.getEdges(node, direction)) {
                boolean step;
                if (!edge.isCausative()) continue;
                Node neigh = this.getEdgeEnd(edge, direction);
                boolean bl = step = neigh.isBreadthNode() && edge.isBreadthEdge();
                if (queue.contains(neigh)) continue;
                if (!this.isVisited(neigh)) {
                    this.putDistance(neigh, root, direction, step ? d + 1 : d);
                    if (step) {
                        queue.addLast(neigh);
                        continue;
                    }
                    if (queue.contains(neigh)) {
                        queue.remove(neigh);
                    }
                    queue.addFirst(neigh);
                    continue;
                }
                if (!neigh.hasLabel(VISITED_WO_CH) && !neigh.hasLabel(VISITED_WO_PR)) continue;
                neigh.putLabel(TEMP_DIST, step ? d + 1 : d);
                if (step) {
                    queue.addLast(neigh);
                    continue;
                }
                if (queue.contains(neigh)) {
                    queue.remove(neigh);
                }
                queue.addFirst(neigh);
            }
        }
        this.markVisited(node);
        if (node.hasLabel(PARENT_LOCK)) {
            node.removeLabel(PARENT_LOCK);
            node.putLabel(VISITED_WO_PR);
        } else if (node.hasLabel(CHILD_LOCK)) {
            node.removeLabel(CHILD_LOCK);
            node.putLabel(VISITED_WO_CH);
        } else if (node.hasLabel(VISITED_WO_CH)) {
            node.removeLabel(VISITED_WO_CH);
        } else if (node.hasLabel(VISITED_WO_PR)) {
            node.removeLabel(VISITED_WO_PR);
        }
    }

    private Map<Node, Integer> getDistMap(Node node, boolean direction) {
        if (!node.hasLabel(direction ? DIST_FROM : DIST_TO)) {
            node.putLabel(direction ? DIST_FROM : DIST_TO, new HashMap());
        }
        return (Map)node.getLabel(direction ? DIST_FROM : DIST_TO);
    }

    private int getDistance(Node node, Node ref, boolean direction) {
        Map<Node, Integer> distmap = this.getDistMap(node, direction);
        int d = Integer.MAX_VALUE;
        if (distmap.containsKey(ref)) {
            d = distmap.get(ref);
        }
        return d;
    }

    private void putDistance(Node node, Node ref, boolean direction, int d) {
        Map<Node, Integer> distmap = this.getDistMap(node, direction);
        distmap.put(ref, d);
    }

    private Node getEdgeEnd(Edge edge, boolean direction) {
        return direction ? edge.getTargetNode() : edge.getSourceNode();
    }

    private Collection<? extends Edge> getEdges(Node node, boolean direction) {
        return direction ? node.getDownstream() : node.getUpstream();
    }

    private void markVisited(Node node) {
        node.putLabel(VISITED, true);
    }

    private boolean isVisited(Node node) {
        return node.hasLabel(VISITED);
    }

    public void clearDistLabels() {
        for (Node node : this.graph.getNodes()) {
            node.removeLabel(DIST_FROM);
            node.removeLabel(DIST_TO);
        }
    }

    private void clearStepLabels() {
        this.graph.removeLabels(Arrays.asList(VISITED, VISITED_WO_CH, VISITED_WO_PR, TEMP_DIST));
    }
}

