/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

public class ParameterContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private static final Log logger = LogFactory.getLog(ParameterContentNegotiationStrategy.class);
    private String parameterName = "format";

    public ParameterContentNegotiationStrategy(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    public void setParameterName(String parameterName) {
        Assert.notNull(parameterName, "'parameterName' is required");
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    protected String getMediaTypeKey(NativeWebRequest request) {
        return request.getParameter(this.getParameterName());
    }

    @Override
    protected void handleMatch(String mediaTypeKey, MediaType mediaType) {
        if (logger.isDebugEnabled()) {
            logger.debug("Requested media type: '" + mediaType + "' based on '" + this.getParameterName() + "'='" + mediaTypeKey + "'");
        }
    }

    @Override
    protected MediaType handleNoMatch(NativeWebRequest request, String key) throws HttpMediaTypeNotAcceptableException {
        throw new HttpMediaTypeNotAcceptableException(this.getAllMediaTypes());
    }
}

