/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.dom;

import jp.gr.xml.relax.dom.IDOMVisitor;
import jp.gr.xml.relax.dom.UDOMVisitor;
import jp.gr.xml.relax.xml.UXML;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLMaker
implements IDOMVisitor {
    protected StringBuffer buffer_ = new StringBuffer();
    protected String encoding_ = "UTF-8";
    protected boolean dom2_ = false;
    protected boolean expandEntityReference_ = false;
    protected boolean emptyElementTag_ = false;

    public void setEncoding(String string) {
        this.encoding_ = string;
    }

    public void setDOM2(boolean bl) {
        this.dom2_ = bl;
    }

    public void setExpandEntityReference(boolean bl) {
        this.expandEntityReference_ = bl;
    }

    public void setEmptyElementTag(boolean bl) {
        this.emptyElementTag_ = bl;
    }

    public String getText() {
        return new String(this.buffer_);
    }

    public boolean enter(Element element) {
        String string = element.getTagName();
        this.buffer_.append("<");
        this.buffer_.append(string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            if (attr.getSpecified()) {
                this.buffer_.append(' ');
                this.enter(attr);
                this.leave(attr);
            }
            ++n2;
        }
        this.buffer_.append(">");
        return true;
    }

    public void leave(Element element) {
        String string = element.getTagName();
        this.buffer_.append("</" + string + ">");
    }

    public boolean enter(Attr attr) {
        this.buffer_.append(attr.getName());
        this.buffer_.append("=\"");
        this.buffer_.append(UXML.escapeAttrQuot(attr.getValue()));
        this.buffer_.append('\"');
        return true;
    }

    public void leave(Attr attr) {
    }

    public boolean enter(Text text) {
        this.buffer_.append(UXML.escapeCharData(text.getData()));
        return true;
    }

    public void leave(Text text) {
    }

    public boolean enter(CDATASection cDATASection) {
        this.buffer_.append("<![CDATA[");
        this.buffer_.append(cDATASection.getData());
        this.buffer_.append("]]>");
        return true;
    }

    public void leave(CDATASection cDATASection) {
    }

    public boolean enter(EntityReference entityReference) {
        this.buffer_.append("&");
        this.buffer_.append(entityReference.getNodeName());
        this.buffer_.append(";");
        return false;
    }

    public void leave(EntityReference entityReference) {
    }

    public boolean enter(Entity entity2) {
        String string = entity2.getNodeName();
        String string2 = entity2.getPublicId();
        String string3 = entity2.getSystemId();
        String string4 = entity2.getNotationName();
        this.buffer_.append("<!ENTITY ");
        this.buffer_.append(string);
        if (string3 != null) {
            if (string2 != null) {
                this.buffer_.append(" PUBLIC \"");
                this.buffer_.append(string2);
                this.buffer_.append("\" \"");
                this.buffer_.append(UXML.escapeSystemQuot(string3));
                this.buffer_.append("\">");
            } else {
                this.buffer_.append(" SYSTEM \"");
                this.buffer_.append(UXML.escapeSystemQuot(string3));
                this.buffer_.append("\">");
            }
            if (string4 != null) {
                this.buffer_.append(" NDATA ");
                this.buffer_.append(string4);
                this.buffer_.append(">");
            }
        } else {
            this.buffer_.append(" \"");
            XMLMaker xMLMaker = new XMLMaker();
            UDOMVisitor.traverseChildren(entity2, xMLMaker);
            this.buffer_.append(UXML.escapeEntityQuot(xMLMaker.getText()));
            this.buffer_.append("\"");
            this.buffer_.append(">");
        }
        return false;
    }

    public void leave(Entity entity2) {
    }

    public boolean enter(ProcessingInstruction processingInstruction) {
        this.buffer_.append("<?");
        this.buffer_.append(processingInstruction.getTarget());
        this.buffer_.append(" ");
        this.buffer_.append(processingInstruction.getData());
        this.buffer_.append("?>");
        return true;
    }

    public void leave(ProcessingInstruction processingInstruction) {
    }

    public boolean enter(Comment comment) {
        this.buffer_.append("<!--");
        this.buffer_.append(comment.getData());
        this.buffer_.append("-->");
        return true;
    }

    public void leave(Comment comment) {
    }

    public boolean enter(Document document) {
        this.buffer_.append("<?xml version=\"1.0\" encoding=\"");
        this.buffer_.append(this.encoding_);
        this.buffer_.append("\" ?>\n");
        return true;
    }

    public void leave(Document document) {
    }

    public boolean enter(DocumentType documentType) {
        if (this.dom2_) {
            String string = documentType.getName();
            String string2 = documentType.getPublicId();
            String string3 = documentType.getSystemId();
            String string4 = documentType.getInternalSubset();
            this.buffer_.append("<!DOCTYPE ");
            this.buffer_.append(string);
            if (string2 != null) {
                this.buffer_.append(" PUBLIC \"");
                this.buffer_.append(string2);
                this.buffer_.append("\"");
            }
            if (string3 != null) {
                this.buffer_.append(" SYSTEM \"");
                this.buffer_.append(string3);
                this.buffer_.append("\"");
            }
            if (string4 != null) {
                this.buffer_.append(" [");
                this.buffer_.append(string4);
                this.buffer_.append("]");
            }
            this.buffer_.append(">\n");
            return true;
        }
        String string = documentType.getName();
        NamedNodeMap namedNodeMap = documentType.getEntities();
        NamedNodeMap namedNodeMap2 = documentType.getNotations();
        this.buffer_.append("<!DOCTYPE ");
        this.buffer_.append(string);
        if (namedNodeMap != null && namedNodeMap.getLength() > 0 || namedNodeMap2 != null && namedNodeMap2.getLength() > 0) {
            this.buffer_.append(" [");
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                XMLMaker xMLMaker = new XMLMaker();
                UDOMVisitor.traverse(namedNodeMap.item(n2), xMLMaker);
                this.buffer_.append(xMLMaker.getText());
                ++n2;
            }
            int n3 = namedNodeMap2.getLength();
            int n4 = 0;
            while (n4 < n3) {
                this.enter((Notation)namedNodeMap2.item(n4));
                this.leave((Notation)namedNodeMap2.item(n4));
                ++n4;
            }
            this.buffer_.append("]");
        }
        this.buffer_.append(">\n");
        return true;
    }

    public void leave(DocumentType documentType) {
    }

    public boolean enter(DocumentFragment documentFragment) {
        return true;
    }

    public void leave(DocumentFragment documentFragment) {
    }

    public boolean enter(Notation notation) {
        String string = notation.getNodeName();
        String string2 = notation.getPublicId();
        String string3 = notation.getSystemId();
        this.buffer_.append("<!NOTATION ");
        this.buffer_.append(string);
        if (string2 != null) {
            this.buffer_.append(" PUBLIC \"");
            this.buffer_.append(string2);
            this.buffer_.append("\"");
            if (string3 != null) {
                this.buffer_.append(" \"");
                this.buffer_.append(UXML.escapeSystemQuot(string3));
                this.buffer_.append("\"");
            }
        } else if (string3 != null) {
            this.buffer_.append(" SYSTEM \"");
            this.buffer_.append(UXML.escapeSystemQuot(string3));
            this.buffer_.append("\"");
        }
        this.buffer_.append(">");
        return true;
    }

    public void leave(Notation notation) {
    }

    public boolean enter(Node node) {
        throw new InternalError(node.toString());
    }

    public void leave(Node node) {
        throw new InternalError(node.toString());
    }

    public boolean isParsedEntity(EntityReference entityReference) {
        String string = entityReference.getNodeName();
        Document document = entityReference.getOwnerDocument();
        DocumentType documentType = document.getDoctype();
        if (documentType == null) {
            return false;
        }
        NamedNodeMap namedNodeMap = documentType.getEntities();
        Entity entity2 = (Entity)namedNodeMap.getNamedItem(string);
        if (entity2 == null) {
            return false;
        }
        return entity2.getNotationName() == null;
    }
}

