/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.command;

import java.util.Set;
import org.biopax.paxtools.command.AbstractPropertyCommand;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class PropertySetCommand<D extends BioPAXElement, R>
extends AbstractPropertyCommand<D, R> {
    private R oldValue;

    PropertySetCommand(D bpe, PropertyEditor<D, R> editor, R value) {
        super(bpe, editor, value);
        if (editor.isMultipleCardinality()) {
            throw new IllegalBioPAXArgumentException();
        }
        Set valueFromBean = editor.getValueFromBean(bpe);
        if (valueFromBean == null || valueFromBean.isEmpty()) {
            this.oldValue = null;
        } else if (valueFromBean.size() > 1) {
            throw new IllegalBioPAXArgumentException();
        }
        this.oldValue = valueFromBean.iterator().next();
    }

    @Override
    protected void undoAction() {
        this.editor.setValueToBean(this.oldValue, this.bpe);
    }

    @Override
    protected void redoAction() {
        this.editor.setValueToBean(this.value, this.bpe);
    }

    public String getPresentationName() {
        return "Set " + this.editor.getProperty() + " of " + this.bpe + " to " + this.value;
    }

    public String getUndoPresentationName() {
        return "Set " + this.editor.getProperty() + " of " + this.bpe + " to " + this.oldValue;
    }

    public String getRedoPresentationName() {
        return "Set " + this.editor.getProperty() + " of " + this.bpe + " to " + this.value;
    }
}

