/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import org.biopax.paxtools.impl.level3.NamedImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioSourceImpl
extends NamedImpl
implements BioSource {
    private static final Logger LOG = LoggerFactory.getLogger(BioSourceImpl.class);
    private CellVocabulary celltype;
    private TissueVocabulary tissue;

    public Class<? extends BioSource> getModelInterface() {
        return BioSource.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof BioSource)) {
            return false;
        }
        BioSource bioSource2 = (BioSource)element;
        return (this.celltype != null ? this.celltype.isEquivalent(bioSource2.getCellType()) : bioSource2.getCellType() == null) && (this.tissue != null ? this.tissue.isEquivalent(bioSource2.getTissue()) : bioSource2.getTissue() == null) && SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, UnificationXref>(this.getXref(), UnificationXref.class), new ClassFilterSet<Xref, UnificationXref>(bioSource2.getXref(), UnificationXref.class));
    }

    @Override
    public int equivalenceCode() {
        int result = 29 * super.equivalenceCode() + (this.celltype != null ? this.celltype.hashCode() : 0);
        result = 29 * result + (this.tissue != null ? this.tissue.hashCode() : 0);
        return result;
    }

    @Override
    public CellVocabulary getCellType() {
        return this.celltype;
    }

    @Override
    public void setCellType(CellVocabulary celltype) {
        this.celltype = celltype;
    }

    @Override
    public TissueVocabulary getTissue() {
        return this.tissue;
    }

    @Override
    public void setTissue(TissueVocabulary tissue) {
        this.tissue = tissue;
    }

    @Override
    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getUri()).append(" ");
            sb.append(this.getName().toString());
            if (this.tissue != null) {
                sb.append(" tissue: ").append(this.tissue.getTerm().toString());
            }
            if (this.celltype != null) {
                sb.append(" celltype: ").append(this.celltype.getTerm().toString());
            }
            sb.append(" xrefs: ").append(this.getXref().toString());
            return sb.toString();
        }
        catch (Exception e) {
            LOG.warn("Error in toString(): ", e);
            return this.getUri();
        }
    }
}

