/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PositionStatusType;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.cbio.causality.util.Histogram;
import org.cbio.causality.util.TermCounter;

public class ModificationMatcher {
    static Map<Provenance, TermCounter> tc = new HashMap<Provenance, TermCounter>();

    public Histogram getModificationFeatureOverlapHistogram(Model model) {
        HashSet<String> useProv = new HashSet<String>(Arrays.asList("PhosphoSitePlus", "pid", "Reactome", "panther", "HumanCyc"));
        for (Provenance pro : model.getObjects(Provenance.class)) {
            System.out.println("pro.getDisplayName() = " + pro.getDisplayName());
        }
        Histogram hist = new Histogram(1.0);
        int totalSeqEnt = 0;
        int seqEntWithMod = 0;
        TermCounter provCnt = new TermCounter();
        for (ProteinReference er : model.getObjects(ProteinReference.class)) {
            if (!(er instanceof SequenceEntityReference)) continue;
            ++totalSeqEnt;
            Map<Provenance, Set<ModificationFeature>> modif = this.collectModifications(er);
            for (Provenance prov : new HashSet<Provenance>(modif.keySet())) {
                if (useProv.contains(prov.getDisplayName())) continue;
                modif.remove(prov);
            }
            if (modif.isEmpty()) continue;
            ++seqEntWithMod;
            for (Provenance prov : modif.keySet()) {
                provCnt.addTerm(prov.getDisplayName());
            }
            Histogram h = this.getOverlapHistogram(modif);
            hist.add(h);
        }
        System.out.println("totalSeqEnt = " + totalSeqEnt);
        System.out.println("seqEntWithMod = " + seqEntWithMod);
        provCnt.print();
        return hist;
    }

    private boolean isHuman(SequenceEntityReference pr) {
        return pr.getOrganism() != null && pr.getOrganism().getDisplayName().equals("Homo sapiens");
    }

    protected Map<Provenance, Set<ModificationFeature>> collectModifications(EntityReference er) {
        HashMap<Provenance, Set<ModificationFeature>> map = new HashMap<Provenance, Set<ModificationFeature>>();
        for (SimplePhysicalEntity pe : er.getEntityReferenceOf()) {
            Set<Provenance> ds = pe.getDataSource();
            for (EntityFeature ef : pe.getFeature()) {
                if (!(ef instanceof ModificationFeature)) continue;
                ModificationFeature mf = (ModificationFeature)ef;
                for (Provenance prov : ds) {
                    if (!map.containsKey(prov)) {
                        map.put(prov, new HashSet());
                    }
                    ((Set)map.get(prov)).add(mf);
                    if (!tc.containsKey(prov)) {
                        tc.put(prov, new TermCounter());
                    }
                    if (mf.getModificationType() == null) continue;
                    tc.get(prov).addTerm(mf.getModificationType().toString());
                }
            }
        }
        return map;
    }

    protected Histogram getOverlapHistogram(Map<Provenance, Set<ModificationFeature>> map) {
        Map<Integer, Map<SequenceModificationVocabulary, Set<Provenance>>> ali = this.alignFeatures(map);
        Histogram h = new Histogram(1.0);
        for (Integer pos : ali.keySet()) {
            Map<SequenceModificationVocabulary, Set<Provenance>> m = ali.get(pos);
            for (SequenceModificationVocabulary type : m.keySet()) {
                h.count(m.get(type).size());
            }
        }
        return h;
    }

    protected Map<Integer, Map<SequenceModificationVocabulary, Set<Provenance>>> alignFeatures(Map<Provenance, Set<ModificationFeature>> map) {
        if (map.size() > 1) {
            System.out.print("");
        }
        HashMap<Integer, Map<SequenceModificationVocabulary, Set<Provenance>>> align = new HashMap<Integer, Map<SequenceModificationVocabulary, Set<Provenance>>>();
        for (Provenance prov : map.keySet()) {
            for (ModificationFeature mf : map.get(prov)) {
                Map m;
                SequenceSite ss;
                PositionStatusType ps;
                SequenceLocation fl;
                SequenceModificationVocabulary type = mf.getModificationType();
                if (type == null || !((fl = mf.getFeatureLocation()) instanceof SequenceSite) || (ps = (ss = (SequenceSite)fl).getPositionStatus()) != PositionStatusType.EQUAL) continue;
                int pos = ss.getSequencePosition();
                if (!align.containsKey(pos)) {
                    align.put(pos, new HashMap());
                }
                if (!(m = (Map)align.get(pos)).containsKey(type)) {
                    m.put(type, new HashSet());
                }
                ((Set)m.get(type)).add(prov);
            }
        }
        return align;
    }
}

