/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.portal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.CBioPortalManager;
import org.cbio.causality.data.portal.CancerStudy;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.data.portal.ExpDataManager;
import org.cbio.causality.data.portal.GeneticProfile;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.cbio.causality.util.ArrayUtil;
import org.cbio.causality.util.Download;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FileUtil;
import org.cbio.causality.util.StudentsT;

public class BroadAccessor {
    private static final String BROAD_DIR = "broad-data/";
    private static final String CACHED_STUDIES_FILE = "studies.txt";
    private static String cacheDir;
    private static String broadDataURL;
    private static List<String> studyCodes;
    private static final String MUTSIG_ANALYSIS_SUBSTR = "MutSigNozzleReport2CV.Level_4";
    private static final String GISTIC_ANALYSIS_SUBSTR = "CopyNumber_Gistic2.Level_4";
    public static final String[] mutsigPartialFileNames;
    public static final String gisticAmpPartialName = "amp_genes";
    public static final String gisticDelPartialName = "del_genes";

    public static void setCacheDir(String dir) {
        cacheDir = dir;
    }

    public static void setBroadDataURL(String url) {
        broadDataURL = url;
        studyCodes = null;
    }

    public static String getBroadDataURL() {
        if (broadDataURL.endsWith("latest/")) {
            try {
                URL url = new URL(broadDataURL);
                URLConnection con = url.openConnection();
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("<h3>") && line.endsWith("analyses  Run</h3>")) {
                        String date = line.substring(line.indexOf(">") + 1, line.indexOf(" "));
                        System.out.println("date = " + date);
                        broadDataURL = broadDataURL.substring(0, broadDataURL.lastIndexOf("l")) + date + "/";
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return broadDataURL;
    }

    public static List<String> getStudyCodes() {
        if (studyCodes == null && (studyCodes = BroadAccessor.readStudiesFromCache()) == null) {
            studyCodes = new ArrayList<String>(30);
            try {
                URL url = new URL(BroadAccessor.getBroadDataURL() + "ingested_data.tsv");
                URLConnection con = url.openConnection();
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    String study;
                    if (!(line.isEmpty() || line.startsWith("#") || line.startsWith("Cohort") || line.startsWith("Totals") || !BroadAccessor.bothMutsigAndGisticAvailable(study = line.substring(0, line.indexOf("\t"))))) {
                        studyCodes.add(study);
                    }
                    line = reader.readLine();
                }
                reader.close();
                HashSet<String> available = new HashSet<String>();
                CBioPortalAccessor acc = new CBioPortalAccessor();
                for (CancerStudy cancerStudy : acc.getCancerStudies()) {
                    if (!cancerStudy.getStudyId().endsWith("_tcga")) continue;
                    available.add(cancerStudy.getStudyId().substring(0, cancerStudy.getStudyId().indexOf("_")).toUpperCase());
                }
                studyCodes.retainAll(available);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!studyCodes.isEmpty()) {
                BroadAccessor.cacheStudies(studyCodes);
            }
        }
        return studyCodes;
    }

    private static List<String> readStudiesFromCache() {
        try {
            if (!new File(BroadAccessor.getStudiesFileName()).exists()) {
                return null;
            }
            ArrayList<String> studies = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(BroadAccessor.getStudiesFileName()));
            String date = reader.readLine() + "/";
            if (!broadDataURL.endsWith(date)) {
                broadDataURL = broadDataURL.substring(0, broadDataURL.lastIndexOf("_") + 1) + date;
            }
            String line = reader.readLine();
            while (line != null) {
                if (!line.isEmpty()) {
                    studies.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
            return studies;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void cacheStudies(List<String> studies) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(BroadAccessor.getStudiesFileName()));
            String s = BroadAccessor.getBroadDataURL();
            s = s.substring(s.indexOf("__") + 2, s.lastIndexOf("/"));
            writer.write(s + "\n");
            for (String study : studies) {
                writer.write(study + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getStudiesFileName() {
        return BroadAccessor.getBroadCacheDir() + CACHED_STUDIES_FILE;
    }

    private static String getBroadDateString() {
        String s = BroadAccessor.getBroadDataURL();
        s = s.substring(s.indexOf("__") + 2, s.lastIndexOf("/"));
        s = s.replaceAll("_", "");
        return s;
    }

    private static String getBroadDataURL(String study) {
        return BroadAccessor.getBroadDataURL() + "data/" + study + "/" + BroadAccessor.getBroadDateString() + "/";
    }

    private static String getBroadCacheDir() {
        if (cacheDir == null) {
            String s = CBioPortalManager.getCacheDir() + File.separator + BROAD_DIR;
            File f = new File(s = s.replaceAll("//", "/"));
            if (!f.exists()) {
                f.mkdirs();
            }
            return s;
        }
        return cacheDir;
    }

    private static List<String> getBroadAnalysisFileNames(String study) {
        ArrayList<String> list = new ArrayList<String>(30);
        try {
            URL url = new URL(BroadAccessor.getBroadDataURL(study));
            URLConnection con = url.openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                String start = "<li><a href=\"";
                if (line.startsWith(start)) {
                    String file = line.substring(start.length(), line.indexOf("\">"));
                    list.add(file);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return list;
    }

    private static String getGisticFileName(List<String> list) {
        for (String s : list) {
            if (!s.contains(GISTIC_ANALYSIS_SUBSTR)) continue;
            return s;
        }
        return null;
    }

    private static String getMutsigFileName(List<String> list) {
        for (String s : list) {
            if (!s.contains(MUTSIG_ANALYSIS_SUBSTR)) continue;
            return s;
        }
        return null;
    }

    private static boolean bothMutsigAndGisticAvailable(String study) {
        List<String> analysisFiles = BroadAccessor.getBroadAnalysisFileNames(study);
        return !analysisFiles.isEmpty() && BroadAccessor.getGisticFileName(analysisFiles) != null && BroadAccessor.getMutsigFileName(analysisFiles) != null;
    }

    private static String getCachedGisticAmpFileName(String study) {
        return BroadAccessor.getBroadCacheDir() + study + "-gistic-amp.txt";
    }

    private static String getCachedGisticDelFileName(String study) {
        return BroadAccessor.getBroadCacheDir() + study + "-gistic-del.txt";
    }

    private static String getCachedMutsigFileName(String study) {
        return BroadAccessor.getBroadCacheDir() + study + "-mutsig.txt";
    }

    private static String getTempFileName() {
        return BroadAccessor.getBroadCacheDir() + "temp.tar.gz";
    }

    private static void deleteTempFile() {
        new File(BroadAccessor.getBroadCacheDir() + "temp.tar.gz").delete();
    }

    private static boolean downloadGistic(String study, List<String> analysisFileNames) {
        String s = BroadAccessor.getGisticFileName(analysisFileNames);
        if (s != null && Download.downloadAsIs(BroadAccessor.getBroadDataURL(study) + s, BroadAccessor.getTempFileName()) && FileUtil.extractEntryContainingNameInTARGZFile(BroadAccessor.getTempFileName(), gisticAmpPartialName, BroadAccessor.getCachedGisticAmpFileName(study)) && FileUtil.extractEntryContainingNameInTARGZFile(BroadAccessor.getTempFileName(), gisticDelPartialName, BroadAccessor.getCachedGisticDelFileName(study))) {
            BroadAccessor.deleteTempFile();
            return true;
        }
        return false;
    }

    private static boolean downloadMutsig(String study, List<String> analysisFileNames) {
        String s = BroadAccessor.getMutsigFileName(analysisFileNames);
        if (s != null && Download.downloadAsIs(BroadAccessor.getBroadDataURL(study) + s, BroadAccessor.getTempFileName())) {
            for (String name : mutsigPartialFileNames) {
                if (!FileUtil.extractEntryContainingNameInTARGZFile(BroadAccessor.getTempFileName(), name, BroadAccessor.getCachedMutsigFileName(study))) continue;
                BroadAccessor.deleteTempFile();
                return true;
            }
        }
        return false;
    }

    public static Set<String> getMutsigGenes(String study, double thr, boolean qval) {
        if (!BroadAccessor.getStudyCodes().contains(study)) {
            System.out.println("Study " + study + " is unknown.");
            return Collections.emptySet();
        }
        HashSet<String> genes = new HashSet<String>();
        String file = BroadAccessor.getCachedMutsigFileName(study);
        if (!new File(file).exists()) {
            BroadAccessor.downloadMutsig(study, BroadAccessor.getBroadAnalysisFileNames(study));
        }
        if (new File(file).exists()) {
            genes.addAll(BroadAccessor.readGenesFromMutsig(study, thr, qval));
        }
        return genes;
    }

    public static Set<String> getGisticGenes(String study, double qvalThr) {
        if (!BroadAccessor.getStudyCodes().contains(study)) {
            System.out.println("Study " + study + " is unknown.");
            return Collections.emptySet();
        }
        HashSet<String> genes = new HashSet<String>();
        List<Set<String>> sets = BroadAccessor.getGisticGeneSets(study, qvalThr);
        for (Set<String> set : sets) {
            genes.addAll(set);
        }
        return genes;
    }

    public static List<Set<String>> getGisticGeneSets(String study, double qvalThr) {
        if (!BroadAccessor.getStudyCodes().contains(study)) {
            System.out.println("Study " + study + " is unknown.");
            return Collections.emptyList();
        }
        String file = BroadAccessor.getCachedGisticAmpFileName(study);
        if (!new File(file).exists()) {
            BroadAccessor.downloadGistic(study, BroadAccessor.getBroadAnalysisFileNames(study));
        }
        if (new File(file).exists()) {
            return BroadAccessor.readGenesFromGistic(study, qvalThr);
        }
        return null;
    }

    private static List<Set<String>> readGenesFromGistic(String study, double qvalThr) {
        ArrayList<Set<String>> list = new ArrayList<Set<String>>();
        String s = FileUtil.getFileContent(BroadAccessor.getCachedGisticAmpFileName(study));
        BroadAccessor.readGisticData(list, s, qvalThr);
        s = FileUtil.getFileContent(BroadAccessor.getCachedGisticDelFileName(study));
        BroadAccessor.readGisticData(list, s, qvalThr);
        return list;
    }

    public static Set<String> readGenesFromMutsig(String study, double thr, boolean qval) {
        HashSet<String> set = new HashSet<String>();
        String s = FileUtil.getFileContent(BroadAccessor.getCachedMutsigFileName(study));
        for (String line : s.split("\n")) {
            String symbol;
            double val;
            if (line.startsWith("rank")) continue;
            String[] token = line.split("\t");
            int index = qval ? token.length - 1 : token.length - 2;
            double d = val = token[index].startsWith("<") ? 0.0 : Double.parseDouble(token[index]);
            if (!(val < thr) || (symbol = HGNC.getSymbol(token[1])) == null) continue;
            set.add(symbol);
        }
        return set;
    }

    public static Map<String, Double> readGenesSignificanceFromMutsig(String study, boolean qval) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        String s = FileUtil.getFileContent(BroadAccessor.getCachedMutsigFileName(study));
        for (String line : s.split("\n")) {
            if (line.startsWith("rank")) continue;
            String[] token = line.split("\t");
            int index = qval ? token.length - 1 : token.length - 2;
            double val = token[index].startsWith("<") ? 0.0 : Double.parseDouble(token[index]);
            String symbol = HGNC.getSymbol(token[1]);
            if (symbol == null) continue;
            map.put(symbol, val);
        }
        return map;
    }

    private static void readGisticData(List<Set<String>> list, String s, double qvalThr) {
        int i;
        String[] line = s.split("\n");
        String[] qvalStr = line[2].split("\t");
        double[] qvals = new double[qvalStr.length - 1];
        for (int i2 = 0; i2 < qvals.length; ++i2) {
            qvals[i2] = Double.parseDouble(qvalStr[i2 + 1]);
        }
        Set[] set = new Set[qvals.length];
        for (i = 0; i < set.length; ++i) {
            set[i] = new HashSet();
        }
        for (i = 4; i < line.length; ++i) {
            String[] gene = line[i].split("\t");
            for (int j = 1; j < gene.length; ++j) {
                String symbol;
                if (qvals[j - 1] >= qvalThr || (symbol = HGNC.getSymbol(gene[j])) == null) continue;
                set[j - 1].add(symbol);
            }
        }
        for (Set mem : set) {
            if (mem.isEmpty()) continue;
            list.add(mem);
        }
    }

    public static List<String> getExpressionVerifiedGistic(String study, double fdrThr) {
        Set<String> gistic = BroadAccessor.getGisticGenes(study, fdrThr);
        System.out.println("initial gistic size = " + gistic.size());
        CBioPortalAccessor acc = BroadAccessor.prepareAccesor(study);
        GeneticProfile expProfile = BroadAccessor.findExpProfile(acc);
        ExpDataManager eman = new ExpDataManager(expProfile, acc.getCurrentCaseList());
        System.out.println("------- Used for exp verification of cna:");
        System.out.println(acc.getCurrentCancerStudy());
        System.out.println(acc.getCurrentCaseList());
        System.out.println(acc.getCurrentGeneticProfiles().get(0));
        System.out.println(expProfile);
        System.out.println("-------");
        HashMap<String, Double> pval = new HashMap<String, Double>();
        for (String gene : gistic) {
            Change type;
            double[] exp;
            Change[] cn;
            AlterationPack alts = acc.getAlterations(gene);
            if (alts == null || (cn = alts.get(Alteration.COPY_NUMBER)) == null || (exp = eman.get(gene)) == null || (type = BroadAccessor.getMajorityChange(cn)) == null) continue;
            boolean[] noChLoc = ArrayUtil.getLocations(cn, Change.NO_CHANGE);
            boolean[] chLoc = ArrayUtil.getLocations(cn, type);
            double[] noChVals = ArrayUtil.subset(exp, noChLoc);
            double[] chVals = ArrayUtil.subset(exp, chLoc);
            if (noChVals.length == 0 || chVals.length == 0) continue;
            double p = StudentsT.getPValOfMeanDifference(noChVals, chVals);
            pval.put(gene, p);
        }
        List<String> select = FDR.select(pval, null, fdrThr);
        System.out.println("Expression filtered gistic size = " + select.size());
        return select;
    }

    private static Change getMajorityChange(Change[] ch) {
        int up = 0;
        int dw = 0;
        for (Change c : ch) {
            if (c == Change.ACTIVATING) {
                ++up;
                continue;
            }
            if (c != Change.INHIBITING) continue;
            ++dw;
        }
        return dw > up ? Change.INHIBITING : (up > dw ? Change.ACTIVATING : null);
    }

    private static CBioPortalAccessor prepareAccesor(String code) {
        code = code.toLowerCase();
        CBioPortalAccessor acc = null;
        try {
            acc = new CBioPortalAccessor();
            ArrayList<CancerStudy> studies = new ArrayList<CancerStudy>();
            for (CancerStudy study : acc.getCancerStudies()) {
                if (!study.getStudyId().substring(0, study.getStudyId().indexOf("_")).equals(code)) continue;
                studies.add(study);
            }
            if (studies.isEmpty()) {
                throw new RuntimeException("Cannot find a related study.");
            }
            if (studies.size() > 1) {
                Collections.sort(studies, new Comparator<CancerStudy>(){

                    @Override
                    public int compare(CancerStudy o1, CancerStudy o2) {
                        return new Integer(o1.getStudyId().length()).compareTo(o2.getStudyId().length());
                    }
                });
            }
            if (code.equals("ucec")) {
                Collections.reverse(studies);
            }
            CaseList cl = null;
            GeneticProfile cna = null;
            for (CancerStudy study : studies) {
                acc.setCurrentCancerStudy(study);
                cl = null;
                for (CaseList caseList : acc.getCaseListsForCurrentStudy()) {
                    if (!caseList.getId().endsWith("complete")) continue;
                    cl = caseList;
                    break;
                }
                if (cl == null) continue;
                for (GeneticProfile profile : acc.getGeneticProfilesForCurrentStudy()) {
                    if (!profile.getId().endsWith("gistic")) continue;
                    cna = profile;
                    break;
                }
                if (cna == null) continue;
                break;
            }
            if (cna == null) {
                throw new RuntimeException("Cannot find cna profile. Please check.");
            }
            acc.setCurrentCaseList(cl);
            acc.getCurrentGeneticProfiles().add(cna);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return acc;
    }

    private static GeneticProfile findExpProfile(CBioPortalAccessor acc) {
        GeneticProfile exp = null;
        try {
            for (GeneticProfile profile : acc.getGeneticProfilesForCurrentStudy()) {
                if (!profile.getId().endsWith("mrna") || !profile.getId().contains("seq")) continue;
                exp = profile;
            }
            if (exp == null) {
                for (GeneticProfile profile : acc.getGeneticProfilesForCurrentStudy()) {
                    if (!profile.getId().endsWith("mrna")) continue;
                    exp = profile;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return exp;
    }

    public static void main(String[] args) {
        Set<String> set = BroadAccessor.getMutsigGenes("BRCA", 0.05, true);
        System.out.println("size = " + set.size());
        System.out.println(set);
    }

    static {
        broadDataURL = "http://gdac.broadinstitute.org/runs/analyses__latest/";
        mutsigPartialFileNames = new String[]{".sig_genes.", "sig_genes."};
    }
}

