/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.portal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cbio.causality.analysis.CNVerifier;
import org.cbio.causality.data.AlterationProviderAdaptor;
import org.cbio.causality.data.portal.CBioPortalManager;
import org.cbio.causality.data.portal.CBioPortalOptions;
import org.cbio.causality.data.portal.CancerStudy;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.data.portal.GeneticProfile;
import org.cbio.causality.data.portal.PortalDataset;
import org.cbio.causality.data.portal.ProfileType;
import org.cbio.causality.idmapping.EntrezGene;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.cbio.causality.model.Node;

public class CBioPortalAccessor
extends AlterationProviderAdaptor {
    private static Log log = LogFactory.getLog(CBioPortalAccessor.class);
    protected CBioPortalManager man = new CBioPortalManager();
    protected CNVerifier cnVerifier;
    protected static final String DELIMITER = "\t";
    private List<CancerStudy> cancerStudies = new ArrayList<CancerStudy>();
    private CancerStudy currentCancerStudy = null;
    private Map<String, CancerStudy> cancerStudiesById = null;
    private Map<String, GeneticProfile> geneticProfilesById = null;
    private Map<String, CaseList> caseListsById = null;
    private Map<CancerStudy, List<GeneticProfile>> geneticProfilesCache = new HashMap<CancerStudy, List<GeneticProfile>>();
    private Map<CancerStudy, List<CaseList>> caseListCache = new HashMap<CancerStudy, List<CaseList>>();
    private CaseList currentCaseList = null;
    private List<GeneticProfile> currentGeneticProfiles = new ArrayList<GeneticProfile>();
    private CBioPortalOptions options;
    final String[] NULLS = new String[]{"", "NaN", "NA", "null"};

    public CBioPortalAccessor(PortalDataset dataset) throws IOException {
        this();
        CancerStudy selectStudy = null;
        for (CancerStudy study : this.cancerStudies) {
            if (!study.getStudyId().equals(dataset.getCancerStudyID())) continue;
            selectStudy = study;
            break;
        }
        if (selectStudy == null) {
            throw new IllegalArgumentException("study not found: " + dataset.getCancerStudyID());
        }
        this.setCurrentCancerStudy(selectStudy);
        CaseList selectList = null;
        for (CaseList list : this.getCaseListsForCurrentStudy()) {
            if (!list.getId().equals(dataset.getCaseListID())) continue;
            selectList = list;
            break;
        }
        if (selectList == null) {
            throw new IllegalArgumentException("case list not found: " + dataset.getCaseListID());
        }
        this.setCurrentCaseList(selectList);
        ArrayList<GeneticProfile> profiles = new ArrayList<GeneticProfile>(dataset.getProfileID().length);
        List<GeneticProfile> available = this.getGeneticProfilesForCurrentStudy();
        for (String profID : dataset.getProfileID()) {
            GeneticProfile selectProf = null;
            for (GeneticProfile prof : available) {
                if (!prof.getId().equals(profID)) continue;
                selectProf = prof;
                break;
            }
            if (selectProf == null) {
                throw new IllegalArgumentException("profile not found: " + profID);
            }
            profiles.add(selectProf);
        }
        assert (profiles.size() == dataset.getProfileID().length);
        this.setCurrentGeneticProfiles(profiles);
    }

    public CBioPortalAccessor() throws IOException {
        this.memory = new HashMap();
        this.setOptions(new CBioPortalOptions());
        this.initializeStudies();
        assert (!this.cancerStudies.isEmpty());
    }

    public void setCnVerifier(CNVerifier cnVerifier) {
        this.cnVerifier = cnVerifier;
    }

    public void setUseCacheOnly(boolean useCacheOnly) {
        this.man.setUseCacheOnly(useCacheOnly);
    }

    public boolean configureForStudy(String studyID) {
        if (this.getCurrentCancerStudy() != null && this.getCurrentCancerStudy().getStudyId().equals(studyID)) {
            return true;
        }
        List<CancerStudy> cancerStudies = this.getCancerStudies();
        for (CancerStudy cancerStudy : cancerStudies) {
            if (!cancerStudy.getStudyId().equals(studyID)) continue;
            this.setCurrentCancerStudy(cancerStudy);
            try {
                for (CaseList caseList : this.getCaseListsForCurrentStudy()) {
                    if (!caseList.getId().contains("cna") || !caseList.getId().contains("seq")) continue;
                    this.setCurrentCaseList(caseList);
                }
                if (this.getCurrentCaseList() == null) {
                    System.err.println("Cannot find case list.");
                    return false;
                }
                ArrayList<GeneticProfile> plist = new ArrayList<GeneticProfile>();
                for (GeneticProfile geneticProfile : this.getGeneticProfilesForCurrentStudy()) {
                    if (!geneticProfile.getId().contains("gistic") && !geneticProfile.getId().contains("mutation")) continue;
                    plist.add(geneticProfile);
                }
                if (plist.isEmpty()) {
                    System.err.println("Cannot find any profile");
                    return false;
                }
                this.setCurrentGeneticProfiles(plist);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.getCurrentCancerStudy() == null || !this.getCurrentCancerStudy().getStudyId().equals(studyID)) {
            System.err.println("Cannot find the TCGA study.");
            return false;
        }
        if (this.getCurrentCaseList() == null) {
            System.err.println("Cannot find the needed case list for study: " + studyID);
            return false;
        }
        return true;
    }

    public void setWithoutCheck(CancerStudy study, CaseList caseList, GeneticProfile ... profiles) {
        this.currentCancerStudy = study;
        this.currentCaseList = caseList;
        this.currentGeneticProfiles.clear();
        Collections.addAll(this.currentGeneticProfiles, profiles);
        this.cancerStudies.add(this.currentCancerStudy);
        if (!this.caseListCache.containsKey(this.currentCancerStudy)) {
            this.caseListCache.put(this.currentCancerStudy, Collections.singletonList(caseList));
        }
    }

    private void initializeStudies() throws IOException {
        this.cancerStudiesById = new HashMap<String, CancerStudy>();
        for (CancerStudy study : this.man.getCancerStudies()) {
            this.cancerStudies.add(study);
            this.cancerStudiesById.put(study.getStudyId(), study);
        }
    }

    public void setOptions(CBioPortalOptions cBioPortalOptions) {
        this.options = cBioPortalOptions;
    }

    public CBioPortalManager getManager() {
        return this.man;
    }

    public CBioPortalOptions getOptions() {
        return this.options;
    }

    public static String getPortalURL() {
        return CBioPortalManager.getPortalURL();
    }

    public static void setPortalURL(String portalURL) {
        CBioPortalManager.setPortalURL(portalURL);
    }

    public GeneticProfile getGeneticProfileById(String id) {
        return this.geneticProfilesById.get(id);
    }

    public CaseList getCaseListById(String id) {
        return this.caseListsById.get(id);
    }

    public CancerStudy getCancerStudyById(String id) {
        return this.cancerStudiesById.get(id);
    }

    private Change[] mergeChanges(Change[] changes1, Change[] changes2) {
        assert (changes1.length == changes2.length);
        Change[] consChanges = new Change[changes1.length];
        for (int i = 0; i < changes1.length; ++i) {
            Change consensus;
            Change c1 = changes1[i];
            Change c2 = changes2[i];
            if (c1.equals(c2)) {
                consensus = c1;
            } else if (c1.equals(Change.NO_DATA)) {
                consensus = c2;
            } else if (c2.equals(Change.NO_DATA)) {
                consensus = c1;
            } else if (c1.equals(Change.NO_CHANGE)) {
                consensus = c2;
            } else if (c2.equals(Change.NO_CHANGE)) {
                consensus = c1;
            } else {
                log.warn("Conflicting values on sample " + i + ": " + c1 + " vs " + c2 + ". Accepting the first value.");
                consensus = c1;
            }
            consChanges[i] = consensus;
        }
        return consChanges;
    }

    private Change[] getDataForCurrentStudy(GeneticProfile geneticProfile, String symbol, CaseList caseList) throws IOException {
        assert (symbol != null && !symbol.isEmpty());
        String s = EntrezGene.getSymbol(symbol);
        if (s != null) {
            symbol = s;
        }
        HashMap<String, Change> changesMap = new HashMap<String, Change>();
        String[] data = this.man.getDataForGene(symbol, geneticProfile, caseList);
        if (data == null) {
            return null;
        }
        if (data.length != caseList.getCases().length) {
            System.err.println("Data length and caselist length do not match. Data: " + data.length + "  " + "caselist: " + caseList.getCases().length + "\nTime to delete the cache!");
            return null;
        }
        for (int j = 0; j < data.length; ++j) {
            Change ch = this.inferChange(geneticProfile, data[j]);
            changesMap.put(caseList.getCases()[j], ch);
        }
        Change[] changes = new Change[caseList.getCases().length];
        int counter = 0;
        for (String aCase : caseList.getCases()) {
            Change change = (Change)changesMap.get(aCase);
            changes[counter++] = change == null ? Change.NO_DATA : change;
        }
        return changes;
    }

    private Change inferChange(GeneticProfile geneticProfile, String dataPoint) {
        switch (ProfileType.convertToAlteration(geneticProfile.getType())) {
            case MUTATION: {
                return this.isNaN(dataPoint) ? Change.NO_CHANGE : (dataPoint.contains("fs") || dataPoint.contains("splice") || dataPoint.contains(">") || dataPoint.contains("del") || dataPoint.contains("-") || dataPoint.contains("+") || dataPoint.contains("*") ? Change.INHIBITING : Change.UNKNOWN_CHANGE);
            }
            case METHYLATION: {
                Double methylationThreshold = (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.METHYLATION_THRESHOLD);
                return this.isNaN(dataPoint) ? Change.NO_DATA : (Double.parseDouble(dataPoint) > methylationThreshold ? Change.INHIBITING : Change.NO_CHANGE);
            }
            case COPY_NUMBER: {
                if (this.isNaN(dataPoint)) {
                    return Change.NO_DATA;
                }
                Double value = Double.parseDouble(dataPoint);
                if (value <= (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.CNA_LOWER_THRESHOLD)) {
                    return Change.INHIBITING;
                }
                if (value >= (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.CNA_UPPER_THRESHOLD)) {
                    return Change.ACTIVATING;
                }
                return Change.NO_CHANGE;
            }
            case EXPRESSION: {
                if (this.isNaN(dataPoint)) {
                    return Change.NO_DATA;
                }
                Double value = Double.parseDouble(dataPoint);
                if (value > (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.EXP_UPPER_THRESHOLD)) {
                    return Change.ACTIVATING;
                }
                if (value < (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.EXP_LOWER_THRESHOLD)) {
                    return Change.INHIBITING;
                }
                return Change.NO_CHANGE;
            }
            case PROTEIN_LEVEL: {
                if (this.isNaN(dataPoint)) {
                    return Change.NO_DATA;
                }
                Double value = Double.parseDouble(dataPoint);
                if (value > (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.RPPA_UPPER_THRESHOLD)) {
                    return Change.ACTIVATING;
                }
                if (value < (Double)this.options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.RPPA_LOWER_THRESHOLD)) {
                    return Change.INHIBITING;
                }
                return Change.NO_CHANGE;
            }
        }
        return Change.NO_CHANGE;
    }

    private boolean isNaN(String s) {
        if (s == null) {
            return true;
        }
        s = s.trim();
        for (String val : this.NULLS) {
            if (!s.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AlterationPack getAlterations(Node node) {
        String symbol = this.getGeneSymbol(node);
        if (symbol != null) {
            return this.getAlterations(symbol);
        }
        return null;
    }

    @Override
    public AlterationPack getAlterations(String symbol) {
        if (symbol == null || symbol.isEmpty()) {
            throw new IllegalArgumentException("symbol cannot be null or empty. symbol = " + symbol);
        }
        AlterationPack alterationPack = this.getFromMemory(symbol);
        if (alterationPack != null) {
            return alterationPack;
        }
        alterationPack = new AlterationPack(symbol);
        CancerStudy cancerStudy = this.currentCancerStudy;
        if (!this.getCancerStudies().contains(cancerStudy)) {
            String message = "Current cancer study is not valid: " + (cancerStudy == null ? "null" : cancerStudy.getName());
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        try {
            if (!this.getCaseListsForCurrentStudy().contains(this.getCurrentCaseList())) {
                CaseList caseList = this.getCurrentCaseList();
                String message = "Current case list is not valid :" + (caseList == null ? "null" : caseList.getDescription());
                log.error(message);
                throw new IllegalArgumentException(message);
            }
            if (this.getCurrentGeneticProfiles().isEmpty()) {
                log.warn("Current genetic profiles do not have any elements in it!");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        for (GeneticProfile geneticProfile : this.currentGeneticProfiles) {
            Change[] altChanges;
            Change[] changes;
            if (!this.getCurrentGeneticProfiles().contains(geneticProfile)) {
                log.warn("the genetic profile " + geneticProfile.getId() + " is not in the available profiles list. Skipping.");
                continue;
            }
            try {
                changes = this.getDataForCurrentStudy(geneticProfile, symbol, this.currentCaseList);
            }
            catch (IOException e) {
                log.error("Could not get data for genetic profile " + geneticProfile.getId() + ". Skipping...");
                continue;
            }
            if (changes == null) {
                if (!log.isInfoEnabled()) continue;
                log.info("Could not get data for symbol " + symbol + " and genetic profile " + geneticProfile.getId() + ". Skipping...");
                continue;
            }
            Alteration alteration = ProfileType.convertToAlteration(geneticProfile.getType());
            if (alteration == null) {
                System.err.println("Unsupported alteration = " + (Object)((Object)geneticProfile.getType()));
            }
            if ((altChanges = alterationPack.get(alteration)) == null) {
                alterationPack.put(alteration, changes);
                continue;
            }
            alterationPack.put(alteration, this.mergeChanges(altChanges, changes));
        }
        if (alterationPack.getAlterationTypes().isEmpty()) {
            return null;
        }
        this.memorize(symbol, alterationPack);
        if (this.cnVerifier != null) {
            this.cnVerifier.verify(alterationPack);
        }
        if (alterationPack.getSize() != this.currentCaseList.getCases().length) {
            System.err.println("Time to clear cache!");
            System.err.println("Cached sample size = " + alterationPack.getSize());
            System.err.println("Current sample size = " + this.currentCaseList.getCases().length);
        }
        return alterationPack;
    }

    public List<CaseList> getCaseListsForCurrentStudy() throws IOException {
        this.caseListsById = new HashMap<String, CaseList>();
        List<CaseList> caseLists = this.caseListCache.get(this.getCurrentCancerStudy());
        if (caseLists != null) {
            for (CaseList caseList : caseLists) {
                this.caseListsById.put(caseList.getId(), caseList);
            }
            return caseLists;
        }
        caseLists = this.man.getCaseListsForStudy(this.getCurrentCancerStudy());
        for (CaseList caseList : caseLists) {
            this.caseListsById.put(caseList.getId(), caseList);
        }
        this.caseListCache.put(this.getCurrentCancerStudy(), caseLists);
        return caseLists;
    }

    public List<CancerStudy> getCancerStudies() {
        return this.cancerStudies;
    }

    public CancerStudy getCurrentCancerStudy() {
        return this.currentCancerStudy;
    }

    public void setCurrentCancerStudy(CancerStudy currentCancerStudy) {
        if (!this.cancerStudies.contains(currentCancerStudy)) {
            throw new IllegalArgumentException("This cancer study is not available through the initialized list.");
        }
        this.currentCancerStudy = currentCancerStudy;
        this.setCurrentCaseList(null);
        if (this.caseListsById != null) {
            this.caseListsById.clear();
        }
        this.getCurrentGeneticProfiles().clear();
        if (this.geneticProfilesById != null) {
            this.geneticProfilesById.clear();
        }
        this.memory.clear();
        try {
            this.getCaseListsForCurrentStudy();
            this.getGeneticProfilesForCurrentStudy();
        }
        catch (IOException e) {
            log.warn("Could not buffer case lists/genetic profiles for the current study:" + currentCancerStudy.getStudyId());
        }
    }

    public List<GeneticProfile> getGeneticProfilesForCurrentStudy() throws IOException {
        this.geneticProfilesById = new HashMap<String, GeneticProfile>();
        List<GeneticProfile> geneticProfiles = this.geneticProfilesCache.get(this.getCurrentCancerStudy());
        if (geneticProfiles != null) {
            for (GeneticProfile geneticProfile : geneticProfiles) {
                this.geneticProfilesById.put(geneticProfile.getId(), geneticProfile);
            }
            return geneticProfiles;
        }
        geneticProfiles = this.man.getGeneticProfilesForStudy(this.getCurrentCancerStudy());
        for (GeneticProfile geneticProfile : geneticProfiles) {
            this.geneticProfilesById.put(geneticProfile.getId(), geneticProfile);
        }
        assert (!geneticProfiles.isEmpty());
        this.geneticProfilesCache.put(this.getCurrentCancerStudy(), geneticProfiles);
        return geneticProfiles;
    }

    public void setCurrentCaseList(CaseList caseList) {
        try {
            List<CaseList> caseListsForCurrentStudy = this.getCaseListsForCurrentStudy();
            if (caseList != null && !caseListsForCurrentStudy.contains(caseList)) {
                throw new IllegalArgumentException("The case list is not available for current cancer study.");
            }
            this.currentCaseList = caseList;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot obtain the case lists for the current study.");
        }
    }

    public CaseList getCurrentCaseList() {
        return this.currentCaseList;
    }

    public void setCurrentGeneticProfiles(List<GeneticProfile> geneticProfiles) {
        this.currentGeneticProfiles = geneticProfiles;
        this.memory.clear();
    }

    public List<GeneticProfile> getCurrentGeneticProfiles() {
        return this.currentGeneticProfiles;
    }

    public GeneticProfile getGeneticProfileContainingName(String name) {
        for (GeneticProfile gp : this.currentGeneticProfiles) {
            if (!gp.getName().toLowerCase().contains(name)) continue;
            return gp;
        }
        return null;
    }

    protected String getGeneSymbol(Node node) {
        String egid = this.getEntrezGeneID(node);
        if (egid != null) {
            return EntrezGene.getSymbol(egid);
        }
        return null;
    }

    public void clearAlterationCache() {
        this.memory.clear();
    }

    public static void setCacheDir(String cacheDir) {
        CBioPortalManager.setCacheDir(cacheDir);
    }
}

