/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.portal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.CBioPortalManager;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.data.portal.GeneticProfile;

public class ExpDataManager {
    private GeneticProfile profile;
    private CaseList caseList;
    private Map<String, double[]> cache;
    private CBioPortalManager cman;
    private Set<String> notFound;
    private boolean takeLog = false;
    public static final double LOG2 = Math.log(2.0);

    public ExpDataManager(CBioPortalAccessor acc) {
        this(acc.getCurrentGeneticProfiles().get(0), acc.getCurrentCaseList());
    }

    public ExpDataManager(GeneticProfile profile, CaseList caseList) {
        this.profile = profile;
        this.caseList = caseList;
        this.cache = new HashMap<String, double[]>();
        this.cman = new CBioPortalManager();
        this.notFound = new HashSet<String>();
    }

    public CaseList getCaseList() {
        return this.caseList;
    }

    public void setTakeLog(boolean takeLog) {
        this.takeLog = takeLog;
    }

    public double[] get(String symbol) {
        String[] data;
        if (this.notFound.contains(symbol)) {
            return null;
        }
        if (!this.cache.containsKey(symbol) && (data = this.cman.getDataForGene(symbol, this.profile, this.caseList)) != null) {
            this.cache.put(symbol, this.stringToDouble(data));
        }
        if (this.cache.containsKey(symbol)) {
            return this.cache.get(symbol);
        }
        this.notFound.add(symbol);
        return null;
    }

    public boolean contains(String gene) {
        return this.get(gene) != null;
    }

    public double getNonZeroRatio(String gene) {
        if (!this.contains(gene)) {
            return 0.0;
        }
        double[] vals = this.get(gene);
        int zero = 0;
        for (double v : vals) {
            if (v != 0.0 && !Double.isNaN(v)) continue;
            ++zero;
        }
        return 1.0 - (double)zero / (double)vals.length;
    }

    private double[] stringToDouble(String[] data) {
        double[] d = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            try {
                double val;
                d[i] = val = Double.parseDouble(data[i]);
                if (!this.takeLog || Double.isNaN(d[i])) continue;
                if (d[i] < 1.0) {
                    d[i] = 1.0;
                }
                d[i] = this.log2(d[i]);
                continue;
            }
            catch (NumberFormatException e) {
                d[i] = Double.NaN;
            }
        }
        return d;
    }

    private double log2(double val) {
        return Math.log(val) / LOG2;
    }
}

