/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.tcgafile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.cbio.causality.util.Download;
import org.cbio.causality.util.FileUtil;
import org.cbio.causality.util.StringUtil;

public class BroadDownloader {
    private static final String BROAD_URL_PREFIX = "http://gdac.broadinstitute.org/runs/";
    private static final String BROAD_DATA_URL_PREFIX = "http://gdac.broadinstitute.org/runs/stddata__";
    private static final String BROAD_ANALYSIS_URL_PREFIX = "http://gdac.broadinstitute.org/runs/analyses__";

    public static void downloadAll(String date, String dir) throws IOException {
        List<String> codes = BroadDownloader.getStudyCodes(date);
        for (String code : codes) {
            BroadDownloader.download(date, dir, code);
        }
    }

    public static void download(String date, String dir, String code) throws IOException {
        Map<ResourceType, String> pack = BroadDownloader.detectURLs(date, code);
        for (ResourceType type : ResourceType.values()) {
            if (pack.containsKey((Object)type)) continue;
            System.out.println("No " + (Object)((Object)type) + " for " + code);
        }
        if (pack.containsKey((Object)ResourceType.CNA)) {
            BroadDownloader.downloadCopyNumber(dir, code, pack.get((Object)ResourceType.CNA));
        }
        if (pack.containsKey((Object)ResourceType.EXPRESSION)) {
            BroadDownloader.downloadExpression(dir, code, pack.get((Object)ResourceType.EXPRESSION));
        }
        if (pack.containsKey((Object)ResourceType.MUTATIONS)) {
            BroadDownloader.downloadMutations(dir, code, pack.get((Object)ResourceType.MUTATIONS));
        }
        if (pack.containsKey((Object)ResourceType.MUTSIG)) {
            BroadDownloader.downloadMutsigScores(dir, code, pack.get((Object)ResourceType.MUTSIG));
        }
        if (pack.containsKey((Object)ResourceType.RPPA)) {
            BroadDownloader.downloadRPPA(dir, code, pack.get((Object)ResourceType.RPPA));
        }
    }

    private static Map<ResourceType, String> detectURLs(String date, String code) throws IOException {
        String d = date.replaceAll("_", "");
        HashMap<ResourceType, String> pack = new HashMap<ResourceType, String>();
        BroadDownloader.detectURLs(BROAD_ANALYSIS_URL_PREFIX + date + "/data/" + code + "/" + d, pack);
        BroadDownloader.detectURLs(BROAD_DATA_URL_PREFIX + date + "/data/" + code + "/" + d, pack);
        return pack;
    }

    private static void detectURLs(String url, Map<ResourceType, String> pack) throws IOException {
        Scanner sc = new Scanner(new URL(url).openStream());
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            block1: for (ResourceType type : ResourceType.values()) {
                for (String match : type.content) {
                    if (pack.containsKey((Object)type)) continue block1;
                    String pointer = StringUtil.fetch(line, match, "\"", "\"");
                    if (pointer == null) continue;
                    pointer = url + "/" + pointer;
                    pack.put(type, pointer);
                }
            }
        }
    }

    public static boolean downloadCopyNumber(String dir, String code, String url) throws IOException {
        String directory = dir + File.separator + code + File.separator;
        String outFile = directory + "copynumber.txt";
        if (new File(outFile).exists()) {
            return true;
        }
        new File(directory).mkdirs();
        String tempFile = directory + "temp.tar.gz";
        if (Download.downloadAsIs(url, tempFile) && FileUtil.extractEntryContainingNameInTARGZFile(tempFile, "all_thresholded.by_genes", directory + "copynumber.txt")) {
            FileUtil.extractEntryContainingNameInTARGZFile(tempFile, "amp_genes.conf_99.txt", directory + "scores-amplified.txt");
            FileUtil.extractEntryContainingNameInTARGZFile(tempFile, "del_genes.conf_99.txt", directory + "scores-deleted.txt");
            return new File(tempFile).delete();
        }
        return false;
    }

    public static boolean downloadMutsigScores(String dir, String code, String url) throws IOException {
        String directory = dir + File.separator + code + File.separator;
        String outFile = directory + "scores-mutsig.txt";
        if (new File(outFile).exists()) {
            return true;
        }
        new File(directory).mkdirs();
        String tempFile = directory + "temp.tar.gz";
        if (Download.downloadAsIs(url, tempFile) && FileUtil.extractEntryContainingNameInTARGZFile(tempFile, "sig_genes.txt", outFile)) {
            return new File(tempFile).delete();
        }
        return false;
    }

    public static boolean downloadExpression(String dir, String code, String url) throws IOException {
        String directory = dir + File.separator + code + File.separator;
        String outFile = directory + "expression.txt";
        if (new File(outFile).exists()) {
            return true;
        }
        new File(directory).mkdirs();
        String tempFile = directory + "temp.tar.gz";
        if (Download.downloadAsIs(url, tempFile) && FileUtil.extractEntryContainingNameInTARGZFile(tempFile, "data.txt", outFile)) {
            return new File(tempFile).delete();
        }
        return false;
    }

    public static boolean downloadMutations(String dir, String code, String url) throws IOException {
        String directory = dir + File.separator + code + File.separator;
        String outFile = directory + "mutation.maf";
        if (new File(outFile).exists()) {
            return true;
        }
        new File(directory).mkdirs();
        String tempFile = directory + "temp.tar.gz";
        if (Download.downloadAsIs(url, tempFile) && FileUtil.extractAllEntriesContainingNameInTARGZFile(tempFile, "maf.txt", directory)) {
            BroadDownloader.uniteMutations(directory, outFile);
            return new File(tempFile).delete();
        }
        return false;
    }

    private static void uniteMutations(String dir, String outFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        File d = new File(dir);
        for (File file : d.listFiles()) {
            if (!file.getName().endsWith(".maf.txt")) continue;
            Scanner sc = new Scanner(file);
            while (sc.hasNextLine()) {
                writer.write(sc.nextLine() + "\n");
            }
            sc.close();
            file.delete();
        }
        writer.close();
    }

    public static boolean downloadRPPA(String dir, String code, String url) throws IOException {
        String directory = dir + File.separator + code + File.separator;
        String outFile = directory + "rppa.txt";
        if (new File(outFile).exists()) {
            return true;
        }
        new File(directory).mkdirs();
        String tempFile = directory + "temp.tar.gz";
        if (Download.downloadAsIs(url, tempFile) && FileUtil.extractEntryContainingNameInTARGZFile(tempFile, ".rppa.txt", outFile)) {
            return new File(tempFile).delete();
        }
        return false;
    }

    public static List<String> getStudyCodes(String date) throws IOException {
        String line;
        ArrayList<String> codes = new ArrayList<String>();
        Scanner sc = new Scanner(new URL(BROAD_DATA_URL_PREFIX + date + "/ingested_data.tsv").openStream());
        sc.nextLine();
        while (sc.hasNextLine() && !(line = sc.nextLine()).startsWith("Totals")) {
            codes.add(line.substring(0, line.indexOf("\t")));
        }
        return codes;
    }

    public static void main(String[] args) throws IOException {
        BroadDownloader.downloadAll("2015_08_21", "/home/babur/Documents/TCGA");
    }

    static enum ResourceType {
        MUTATIONS(".Mutation_Packager_Calls.Level_3."),
        CNA(".CopyNumber_Gistic2.Level_4."),
        EXPRESSION(".Merge_rnaseqv2__illuminahiseq_rnaseqv2__unc_edu__Level_3__RSEM_genes_normalized__data.Level_3."),
        MUTSIG(".MutSigNozzleReport2CV.Level_4."),
        RPPA(".RPPA_AnnotateWithGene.Level_3.");

        String[] content;

        private ResourceType(String ... content) {
            this.content = content;
        }
    }
}

