/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.Change;
import org.cbio.causality.util.Summary;

public class AlterationPack
implements Serializable {
    protected Map<Alteration, Change[]> map;
    protected int size;
    protected String id;
    public static final Alteration[] priority_nonGenomic = new Alteration[]{Alteration.PROTEIN_LEVEL, Alteration.EXPRESSION};
    public static final Alteration[] priority_genomic = new Alteration[]{Alteration.MUTATION, Alteration.CONFIRMED_COPY_NUMBER};
    public static final Alteration[] priority = new Alteration[]{Alteration.MUTATION, Alteration.PROTEIN_LEVEL, Alteration.EXPRESSION, Alteration.COPY_NUMBER, Alteration.METHYLATION};

    public AlterationPack(String id) {
        this.id = id;
        this.map = new HashMap<Alteration, Change[]>();
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public String getId() {
        return this.id;
    }

    public void put(Alteration alt, Change[] changes) {
        if (changes.length == 0) {
            throw new IllegalArgumentException("Changes array is empty.");
        }
        if (this.containsNull(changes)) {
            throw new IllegalArgumentException("Changes array contains null change.");
        }
        if (this.size > 0 && this.size != changes.length) {
            throw new IllegalArgumentException("Length of the change array should be equal tothe existing change arrays in the pack. Parameter length = " + changes.length + ". In the pack = " + this.map.values().iterator().next().length);
        }
        this.map.put(alt, changes);
        this.size = changes.length;
    }

    private boolean containsNull(Change[] changes) {
        for (Change ch : changes) {
            if (ch != null) continue;
            return true;
        }
        return false;
    }

    public Change[] get(Alteration alt) {
        return this.map.get(alt);
    }

    public Set<Alteration> getAlterationTypes() {
        return this.map.keySet();
    }

    public boolean isAltered() {
        for (Alteration alt : this.map.keySet()) {
            for (Change ch : this.map.get(alt)) {
                if (!ch.isAltered()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAltered(Alteration alt) {
        if (!this.map.containsKey(alt)) {
            return false;
        }
        for (Change ch : this.map.get(alt)) {
            if (!ch.isAltered()) continue;
            return true;
        }
        return false;
    }

    public boolean isAbsent(Alteration alt) {
        if (!this.map.containsKey(alt)) {
            return true;
        }
        for (Change ch : this.map.get(alt)) {
            if (ch.isAbsent()) continue;
            return false;
        }
        return true;
    }

    public int getAlteredCount(Alteration alt) {
        if (!this.map.containsKey(alt)) {
            return 0;
        }
        int i = 0;
        for (Change ch : this.map.get(alt)) {
            if (!ch.isAltered()) continue;
            ++i;
        }
        return i;
    }

    public double getAlteredRatio() {
        double[] cases = new double[this.map.values().iterator().next().length];
        for (Alteration alt : this.map.keySet()) {
            Change[] changes = this.map.get(alt);
            for (int i = 0; i < changes.length; ++i) {
                if (!changes[i].isAltered()) continue;
                cases[i] = 1.0;
            }
        }
        return Summary.mean(cases);
    }

    public double getAlteredRatio(Alteration alt) {
        int cnt = 0;
        for (Change change : this.map.get(alt)) {
            if (!change.isAltered()) continue;
            ++cnt;
        }
        return (double)cnt / (double)this.size;
    }

    public Change getChange(Alteration alt, int index) {
        if (!this.map.containsKey(alt)) {
            return Change.NO_DATA;
        }
        Change[] changes = this.map.get(alt);
        if (changes.length <= index) {
            throw new IllegalArgumentException("Index is out of loaded cases. index = " + index + " case size = " + changes.length);
        }
        return changes[index];
    }

    public int countAltered(Alteration key) {
        int cnt = 0;
        for (Change ch : this.get(key)) {
            if (!ch.isAltered()) continue;
            ++cnt;
        }
        return cnt;
    }

    public double calcAlteredRatio(Alteration key) {
        double cnt = this.countAltered(key);
        return cnt / (double)this.get(key).length;
    }

    public Change getCumulativeChange(Alteration[] priority, int index) {
        boolean dataExists = false;
        for (Alteration alt : priority) {
            Change ch = this.getChange(alt, index);
            if (!ch.isAbsent()) {
                dataExists = true;
            }
            if (!ch.isAltered()) continue;
            return ch;
        }
        return dataExists ? Change.NO_CHANGE : Change.NO_DATA;
    }

    public void complete(Alteration ... alt) {
        int i;
        if (this.map.isEmpty()) {
            return;
        }
        HashSet<Alteration> set = new HashSet<Alteration>(Arrays.asList(alt));
        int size = this.map.values().iterator().next().length;
        if (set.isEmpty() || set.contains(Alteration.ANY)) {
            Change[] changes = new Change[this.map.values().iterator().next().length];
            for (int i2 = 0; i2 < changes.length; ++i2) {
                changes[i2] = this.getCumulativeChange(priority, i2);
            }
            this.map.put(Alteration.ANY, changes);
        }
        Change[] cnc = this.get(Alteration.COPY_NUMBER);
        Change[] exp = this.get(Alteration.EXPRESSION);
        if ((set.isEmpty() || set.contains(Alteration.CONFIRMED_COPY_NUMBER)) && exp != null && cnc != null) {
            Change[] conf = new Change[size];
            for (i = 0; i < conf.length; ++i) {
                conf[i] = exp[i] == cnc[i] ? exp[i] : (exp[i].isAbsent() || cnc[i].isAbsent() ? Change.NO_DATA : Change.NO_CHANGE);
            }
            this.map.put(Alteration.CONFIRMED_COPY_NUMBER, conf);
        }
        if (set.isEmpty() || set.contains(Alteration.GENOMIC)) {
            Change[] changes = new Change[size];
            for (i = 0; i < changes.length; ++i) {
                changes[i] = this.getCumulativeChange(new Alteration[]{Alteration.MUTATION, this.map.containsKey(Alteration.CONFIRMED_COPY_NUMBER) ? Alteration.CONFIRMED_COPY_NUMBER : Alteration.COPY_NUMBER}, i);
            }
            this.map.put(Alteration.GENOMIC, changes);
        }
    }

    protected boolean containsAlterationType(Alteration[] alts) {
        for (Alteration alt : alts) {
            if (!this.map.containsKey(alt)) continue;
            return true;
        }
        return false;
    }

    public double getParallelChangeRatio(AlterationPack pack, boolean similar) {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            Change ch1 = this.getChange(Alteration.ANY, i);
            Change ch2 = pack.getChange(Alteration.ANY, i);
            if (!ch1.isAltered() || !ch2.isAltered() || (!similar || ch1 != ch2) && (similar || ch1 == ch2)) continue;
            ++count;
        }
        return (double)count / (double)this.size;
    }

    public List<Integer> getParallelChangedIndexes(AlterationPack pack, boolean similar, boolean thisIsUp) {
        ArrayList<Integer> inds = new ArrayList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            Change ch1 = this.getChange(Alteration.ANY, i);
            if (thisIsUp && ch1 == Change.INHIBITING || !thisIsUp && ch1 == Change.ACTIVATING) continue;
            Change ch2 = pack.getChange(Alteration.ANY, i);
            if (!ch1.isAltered() || !ch2.isAltered() || (!similar || ch1 != ch2) && (similar || ch1 == ch2)) continue;
            inds.add(i);
        }
        return inds;
    }

    public Change[] getChangesMissingRemoved(AlterationPack pack, Alteration alt) {
        Change[] ch1 = this.map.get(alt);
        Change[] ch2 = pack.get(alt);
        assert (ch1.length == ch2.length);
        boolean[] b = new boolean[ch1.length];
        int x = 0;
        for (int i = 0; i < ch1.length; ++i) {
            if (!ch1[i].isAbsent() && !ch2[i].isAbsent()) {
                ++x;
                b[i] = true;
                continue;
            }
            b[i] = false;
        }
        Change[] ch = new Change[x];
        int j = 0;
        for (int i = 0; i < ch1.length; ++i) {
            if (!b[i]) continue;
            ch[j++] = ch1[i];
            assert (!ch1[i].isAbsent() && !ch2[i].isAbsent());
        }
        assert (j == ch.length);
        return ch;
    }

    public String getPrint(Alteration key) {
        Change[] ch = this.get(key);
        StringBuilder buf = new StringBuilder();
        for (Change c : ch) {
            buf.append(c.isAltered() ? "x" : (c.isAbsent() ? " " : "."));
        }
        buf.append("  ").append(this.id);
        return buf.toString();
    }

    public String getPrint(Alteration key, List<Integer> order) {
        assert (new HashSet<Integer>(order).size() == order.size());
        Change[] ch = this.get(key);
        StringBuilder buf = new StringBuilder();
        for (Integer o : order) {
            buf.append(ch[o].isAltered() ? "x" : (ch[o].isAbsent() ? " " : (key == Alteration.ACTIVATING && this.get(Alteration.INHIBITING)[o].isAltered() || key == Alteration.INHIBITING && this.get(Alteration.ACTIVATING)[o].isAltered() ? ":" : ".")));
        }
        for (int i = 0; i < ch.length; ++i) {
            if (order.contains(i)) continue;
            buf.append(ch[i].isAltered() ? "x" : (ch[i].isAbsent() ? " " : (key == Alteration.ACTIVATING && this.get(Alteration.INHIBITING)[i].isAltered() || key == Alteration.INHIBITING && this.get(Alteration.ACTIVATING)[i].isAltered() ? ":" : ".")));
        }
        buf.append("  ").append(this.id);
        return buf.toString();
    }

    public static void writeToFile(Map<String, AlterationPack> map, String filename) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        for (AlterationPack pack : map.values()) {
            for (Alteration alt : pack.getAlterationTypes()) {
                if (alt.isSummary()) continue;
                writer.write(pack.getId() + "\t" + alt);
                for (Change c : pack.get(alt)) {
                    writer.write("\t" + c.getLetter());
                }
                writer.write("\n");
            }
        }
        writer.close();
    }

    public static Map<String, AlterationPack> readFromFile(String filename, Alteration ... alts) throws IOException {
        return AlterationPack.readFromFile(new FileReader(filename), alts);
    }

    public static Map<String, AlterationPack> readFromFile(Reader rdr, Alteration ... alts) throws IOException {
        HashSet<Alteration> altSet = new HashSet<Alteration>(Arrays.asList(alts));
        HashMap<String, AlterationPack> map = new HashMap<String, AlterationPack>();
        BufferedReader reader = new BufferedReader(rdr);
        String line = reader.readLine();
        while (line != null) {
            String[] token = line.split("\t");
            if (token.length >= 3) {
                if (!map.containsKey(token[0])) {
                    map.put(token[0], new AlterationPack(token[0]));
                }
                Change[] c = new Change[token.length - 2];
                for (int i = 2; i < token.length; ++i) {
                    c[i - 2] = Change.getChange(token[i]);
                }
                Alteration type = Alteration.valueOf(token[1]);
                if (altSet.isEmpty() || altSet.contains(type)) {
                    ((AlterationPack)map.get(token[0])).put(type, c);
                }
            }
            line = reader.readLine();
        }
        reader.close();
        return map;
    }
}

