/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.model;

import java.io.Serializable;

public enum Change implements Serializable
{
    ACTIVATING("a", true, false),
    INHIBITING("i", true, false),
    UNKNOWN_CHANGE("u", true, false),
    STAY_INACTIVE("s", false, false),
    NO_CHANGE(".", false, false),
    NO_DATA("-", false, true);

    boolean absent;
    boolean altered;
    String letter;

    private Change(String letter, boolean altered, boolean absent) {
        this.absent = absent;
        this.altered = altered;
        this.letter = letter;
    }

    public boolean isAbsent() {
        return this.absent;
    }

    public boolean isAltered() {
        return this.altered;
    }

    public String getLetter() {
        return this.letter;
    }

    public boolean isOpposing(Change ch) {
        return this == ACTIVATING && ch == INHIBITING || this == INHIBITING && ch == ACTIVATING;
    }

    public static Change getChange(String letter) {
        for (Change c : Change.values()) {
            if (!c.getLetter().equals(letter)) continue;
            return c;
        }
        return null;
    }
}

