/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.biopax.paxtools.query.model.Edge;
import org.cbio.causality.model.Node;
import org.cbio.causality.model.PathUser;
import org.cbio.causality.wrapper.ControlWrapper;
import org.cbio.causality.wrapper.ConversionWrapper;
import org.cbio.causality.wrapper.PhysicalEntityWrapper;
import org.cbio.causality.wrapper.TemplateReactionWrapper;

public class Path
implements Cloneable {
    protected LinkedList<Node> nodes;
    protected LinkedList<Edge> edges;
    protected boolean reverse;
    protected int sign;
    protected int length;
    HashSet<Node> nodeSet = new HashSet();
    protected PathUser user;

    public Path(Node initial) {
        this(initial, null);
    }

    public Path(Node initial, PathUser user) {
        this.nodes = new LinkedList();
        this.edges = new LinkedList();
        this.nodes.add(initial);
        this.nodeSet.add(initial);
        this.reverse = false;
        this.sign = 1;
        this.length = 0;
        this.user = user;
    }

    public Object clone() throws CloneNotSupportedException {
        Path clone = (Path)super.clone();
        clone.nodes = (LinkedList)this.nodes.clone();
        clone.edges = (LinkedList)this.edges.clone();
        clone.nodeSet = (HashSet)this.nodeSet.clone();
        return clone;
    }

    public int getSign() {
        return this.sign;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void add(Node node, Edge edge) {
        if (this.nodeSet.contains(node)) {
            throw new IllegalArgumentException("The node is already on the path. Node: " + node);
        }
        if (edge != null && (!this.reverse && edge.getSourceNode() != this.nodes.getLast() || this.reverse && edge.getTargetNode() != this.nodes.getLast())) {
            throw new IllegalArgumentException("The edge is not leading to or coming from the last node in the current list.");
        }
        this.nodes.add(node);
        this.edges.add(edge);
        this.nodeSet.add(node);
        if (edge != null) {
            this.sign *= edge.getSign();
        }
        if (node.isBreadthNode() && edge != null) {
            ++this.length;
        }
        if (this.user != null) {
            this.user.processPath(this);
        }
    }

    public void removeLast() {
        Node node = this.nodes.removeLast();
        Edge edge = this.edges.removeLast();
        this.nodeSet.remove(node);
        if (edge != null) {
            this.sign *= edge.getSign();
        }
        if (node.isBreadthNode() && edge != null) {
            --this.length;
        }
    }

    public boolean contains(Node node) {
        return this.nodeSet.contains(node);
    }

    public boolean canAdd(Node node) {
        if (this.nodeSet.contains(node)) {
            return false;
        }
        for (Node n : this.nodes) {
            if (!n.getBanned().contains(node)) continue;
            return false;
        }
        return true;
    }

    public Node getFirstNode() {
        return this.nodes.getFirst();
    }

    public Node getLastNode() {
        return this.nodes.getLast();
    }

    public Edge getLastEdge() {
        return this.edges.getLast();
    }

    public int getNodeSize() {
        return this.nodes.size();
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        int i;
        String s = this.nodes.get(this.reverse ? this.nodes.size() - 1 : 0).toString();
        int n = i = this.reverse ? this.edges.size() - 1 : 0;
        while (this.reverse ? i >= 0 : i < this.edges.size()) {
            Edge e = this.edges.get(i);
            s = e == null ? s + " --- " : s + (e.getSign() == 1 ? " --> " : " --| ");
            Node n2 = this.nodes.get(this.reverse ? i : i + 1);
            if (n2 instanceof PhysicalEntityWrapper) {
                s = s + n2.toString();
            } else if (n2 instanceof ConversionWrapper || n2 instanceof TemplateReactionWrapper) {
                s = s + "[]";
            } else if (n2 instanceof ControlWrapper) {
                s = s + "<>";
            }
            i = this.reverse ? i - 1 : i + 1;
        }
        return s;
    }

    public Map<Node, Integer> getSignMapping(Integer firstNodeSign) {
        HashMap<Node, Integer> map = new HashMap<Node, Integer>();
        map.put(this.nodes.getFirst(), firstNodeSign);
        int sign = firstNodeSign;
        for (int i = 0; i < this.edges.size(); ++i) {
            Node node = this.nodes.get(i + 1);
            Edge edge = this.edges.get(i);
            if (edge != null) {
                sign *= edge.getSign();
            }
            if (!node.isBreadthNode()) continue;
            map.put(node, sign);
        }
        return map;
    }

    public Map<Node, Integer> getIntermediateSignMapping(Integer firstNodeSign) {
        HashMap<Node, Integer> map = new HashMap<Node, Integer>();
        int sign = firstNodeSign;
        for (int i = 0; i < this.edges.size() - 1; ++i) {
            Node node = this.nodes.get(i + 1);
            Edge edge = this.edges.get(i);
            if (edge != null) {
                sign *= edge.getSign();
            }
            if (!node.isBreadthNode()) continue;
            map.put(node, sign);
        }
        return map;
    }
}

