/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.util.Scanner;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.idmapping.HGNC;

public class MSigDBMIR {
    private static Graph graph = new Graph("MIR", SIFEnum.CONTROLS_EXPRESSION_OF.getTag());

    public static Graph getGraph() {
        return graph;
    }

    public static void main(String[] args) {
        Graph graph = MSigDBMIR.getGraph();
        System.out.println(graph.getDownstream("MIR-17-3P"));
    }

    static {
        Scanner sc = new Scanner(MSigDBMIR.class.getResourceAsStream("msigdb-mir.gmt"));
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            for (String mir : token[0].split(",")) {
                if (!mir.startsWith("MIR-")) continue;
                for (int i = 2; i < token.length; ++i) {
                    token[i] = HGNC.getSymbol(token[i]);
                    if (token[i] == null) continue;
                    graph.putRelation(mir, token[i], true);
                }
            }
        }
    }
}

