/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Xref;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;

public class PCPathwayExtracellular {
    private static Map<String, Set<String>> gene2pathway;
    private static Map<String, Set<String>> pathway2gene;
    private static Map<String, String> pathway2name;
    private static final String FILE = "pcpathway-extracellular.txt";

    public static Set<String> getPathways(String gene) {
        if (gene2pathway.containsKey(gene)) {
            return gene2pathway.get(gene);
        }
        return Collections.emptySet();
    }

    public static Set<String> getGenes(String pathwayID) {
        if (pathway2gene.containsKey(pathwayID)) {
            return pathway2gene.get(pathwayID);
        }
        return Collections.emptySet();
    }

    public static String getName(String id) {
        return pathway2name.get(id);
    }

    public static String getCoverageStr(String id, Set<String> genes) {
        if (!pathway2gene.containsKey(id)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(genes);
        set.retainAll((Collection)pathway2gene.get(id));
        return set.size() + "/" + pathway2gene.get(id).size();
    }

    public static Map<String, Double>[] getEnrichmentPvals(Collection<String> genes, Collection<String> background) {
        if (background == null && !(background = new HashSet<String>(gene2pathway.keySet())).containsAll(genes)) {
            HashSet<String> set = new HashSet<String>(genes);
            set.removeAll(background);
            genes = new HashSet<String>(genes);
            genes.removeAll(set);
            System.out.println("Removed " + set.size() + " unknown genes: " + set);
            System.out.println("Using " + genes.size() + ": " + genes);
        }
        if (!background.containsAll(genes)) {
            throw new IllegalArgumentException("Background genes have to contain all the selected genes.");
        }
        Map<String, Integer> selectionCnt = PCPathwayExtracellular.count(genes);
        Map<String, Integer> backgroundCnt = PCPathwayExtracellular.count(background);
        HashMap<String, Double> mapP = new HashMap<String, Double>();
        HashMap<String, Double> mapL = new HashMap<String, Double>();
        for (String pathway2 : selectionCnt.keySet()) {
            double pval = FishersExactTest.calcEnrichmentPval(background.size(), backgroundCnt.get(pathway2), genes.size(), selectionCnt.get(pathway2));
            double limit = FishersExactTest.calcEnrichmentPval(background.size(), backgroundCnt.get(pathway2), genes.size(), Math.min(backgroundCnt.get(pathway2), genes.size()));
            mapP.put(pathway2, pval);
            mapL.put(pathway2, limit);
        }
        return new Map[]{mapP, mapL};
    }

    private static Map<String, Integer> count(Collection<String> genes) {
        HashMap<String, Integer> cnt = new HashMap<String, Integer>();
        for (String pathway2 : pathway2gene.keySet()) {
            HashSet mems = new HashSet(pathway2gene.get(pathway2));
            mems.retainAll(genes);
            if (mems.isEmpty()) continue;
            cnt.put(pathway2, mems.size());
        }
        return cnt;
    }

    public static List<String> getEnrichedPathways(Collection<String> genes, Collection<String> background, double fdrThr) {
        Map<String, Double>[] map = PCPathwayExtracellular.getEnrichmentPvals(genes, background);
        if (fdrThr < 0.0) {
            fdrThr = FDR.decideBestFDR_BH(map[0], map[1]);
            System.out.println("fdrThr = " + fdrThr);
        }
        return FDR.select(map[0], map[1], fdrThr);
    }

    public static TreeMap<String, Integer> getSortedPathways(Collection<String> genes) {
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String gene : genes) {
            for (String pathway2 : PCPathwayExtracellular.getPathways(gene)) {
                if (map.containsKey(pathway2)) {
                    map.put(pathway2, (Integer)map.get(pathway2) + 1);
                    continue;
                }
                map.put(pathway2, 1);
            }
        }
        TreeMap<String, Integer> sorted = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)map.get(o2)).compareTo((Integer)map.get(o1));
            }
        });
        sorted.putAll(map);
        return sorted;
    }

    public static void main(String[] args) throws IOException {
        PCPathwayExtracellular.prepareResource();
    }

    private static void prepareResource() throws IOException {
        pathway2gene = new HashMap<String, Set<String>>();
        gene2pathway = new HashMap<String, Set<String>>();
        pathway2name = new HashMap<String, String>();
        SimpleIOHandler h = new SimpleIOHandler();
        Model model = h.convertFromOWL(new FileInputStream("../biopax-pattern/Pathway Commons.6.Detailed_Process_Data.BIOPAX.owl"));
        for (Pathway pathway2 : model.getObjects(Pathway.class)) {
            String id = pathway2.getUri();
            String name = pathway2.getDisplayName();
            if (name == null || name.isEmpty()) continue;
            pathway2name.put(id, name);
            Model m = PCPathwayExtracellular.excise(model, pathway2);
            Set<String> syms = PCPathwayExtracellular.collectGeneSymbols(m);
            if (syms.isEmpty()) continue;
            if (!pathway2gene.containsKey(id)) {
                pathway2gene.put(id, new HashSet());
            }
            for (String sym : syms) {
                if (!gene2pathway.containsKey(sym)) {
                    gene2pathway.put(sym, new HashSet());
                }
                pathway2gene.get(id).add(sym);
                gene2pathway.get(sym).add(id);
            }
        }
        PCPathwayExtracellular.writeResources();
    }

    private static void writeResources() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("src/main/resources/org/cbio/causality/network/pcpathway-extracellular.txt"));
        for (String id : pathway2gene.keySet()) {
            if (pathway2gene.get(id).isEmpty()) continue;
            writer.write(id + "\t" + pathway2name.get(id));
            for (String sym : pathway2gene.get(id)) {
                writer.write("\t" + sym);
            }
            writer.write("\n");
        }
        writer.close();
    }

    private static void readResources() {
        pathway2gene = new HashMap<String, Set<String>>();
        gene2pathway = new HashMap<String, Set<String>>();
        pathway2name = new HashMap<String, String>();
        Scanner sc = new Scanner(PCPathwayExtracellular.class.getResourceAsStream(FILE));
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            pathway2name.put(token[0], token[1]);
            if (token.length > 2) {
                pathway2gene.put(token[0], new HashSet<String>(Arrays.asList(token).subList(2, token.length)));
            }
            for (int i = 2; i < token.length; ++i) {
                if (!gene2pathway.containsKey(token[i])) {
                    gene2pathway.put(token[i], new HashSet());
                }
                gene2pathway.get(token[i]).add(token[0]);
            }
        }
    }

    private static Model excise(Model model, Pathway pathway2) {
        Completer c = new Completer(SimpleEditorMap.L3);
        Set<BioPAXElement> objects = c.complete(Collections.singleton(pathway2), model);
        Cloner cln = new Cloner(SimpleEditorMap.L3, BioPAXLevel.L3.getDefaultFactory());
        return cln.clone(model, objects);
    }

    private static Set<String> collectGeneSymbols(Model model) {
        HashSet<String> symbols = new HashSet<String>();
        Completer c = new Completer(SimpleEditorMap.L3);
        for (PhysicalEntity pe : model.getObjects(PhysicalEntity.class)) {
            if (!PCPathwayExtracellular.extracellular(pe)) continue;
            Set<BioPAXElement> set = c.complete(new HashSet<BioPAXElement>(Collections.singleton(pe)), model);
            for (BioPAXElement ele : set) {
                if (!(ele instanceof ProteinReference)) continue;
                ProteinReference pr = (ProteinReference)ele;
                for (Xref xref2 : pr.getXref()) {
                    String s;
                    if (xref2.getDb() == null || !xref2.getDb().equals("HGNC SYMBOL") || (s = HGNC.getSymbol(xref2.getId())) == null) continue;
                    symbols.add(s);
                }
            }
        }
        return symbols;
    }

    private static boolean extracellular(PhysicalEntity pe) {
        CellularLocationVocabulary location = pe.getCellularLocation();
        if (location != null) {
            for (String term : location.getTerm()) {
                if (term == null || !term.toLowerCase().contains("extracellular")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        PCPathwayExtracellular.readResources();
    }
}

