/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.analysis.GraphList;
import org.cbio.causality.util.Download;

public class PathwayCommonsSeparated {
    private static final String url = "http://cbio.mskcc.org/~ozgun/PCWithLoc.sif.zip";
    private static final String tempFile = "PCWithLoc.sif";
    private static final String dir = "PC-res/";

    public static Graph getGraph(Set<String> sources, SIFType ... types) {
        if (PathwayCommonsSeparated.fileExists(types)) {
            if (types.length == 1) {
                return PathwayCommonsSeparated.getSingleGraph(types[0], sources);
            }
            if (types.length > 1) {
                GraphList graph = new GraphList("Pathway Commons");
                for (SIFType type : types) {
                    graph.addGraph(PathwayCommonsSeparated.getSingleGraph(type, sources));
                }
                return graph;
            }
        }
        return null;
    }

    public static Graph getSingleGraph(SIFType type, Set<String> sources) {
        Scanner sc;
        String edgeType = type.getTag();
        Graph graph = new Graph("Pathway Commons", edgeType);
        try {
            sc = new Scanner(new FileInputStream(dir + type.getTag() + ".txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            boolean valid = false;
            for (String res : token[2].split(";")) {
                if (!sources.contains(res)) continue;
                valid = true;
                break;
            }
            if (!valid) continue;
            graph.putRelation(token[0], token[1], type.isDirected());
        }
        return graph;
    }

    private static boolean fileExists(SIFType ... types) {
        if (!PathwayCommonsSeparated.fileExistsJustCheck(types)) {
            if (!new File(tempFile).exists()) {
                Download.downloadAndUncompress(url, tempFile);
            }
            PathwayCommonsSeparated.extractData();
        }
        return PathwayCommonsSeparated.fileExistsJustCheck(types);
    }

    private static boolean fileExistsJustCheck(SIFType[] types) {
        boolean present = true;
        for (SIFType type : types) {
            if (new File(dir + type.getTag() + ".txt").exists()) continue;
            present = false;
            break;
        }
        return present;
    }

    private static boolean extractData() {
        try {
            Scanner sc = new Scanner(new File(tempFile));
            HashMap<String, BufferedWriter> writers = new HashMap<String, BufferedWriter>();
            new File(dir).mkdirs();
            HashSet res = new HashSet();
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                String[] token = line.split("\t");
                if (token.length <= 2) continue;
                if (!writers.containsKey(token[1])) {
                    writers.put(token[1], new BufferedWriter(new FileWriter(dir + token[1] + ".txt")));
                }
                ((Writer)writers.get(token[1])).write(token[0] + "\t" + token[2]);
                if (token.length > 5) {
                    ((Writer)writers.get(token[1])).write("\t" + token[5]);
                    Collections.addAll(res, token[5].split(";"));
                }
                ((Writer)writers.get(token[1])).write("\n");
            }
            for (Writer writer : writers.values()) {
                writer.close();
            }
            new File(tempFile).delete();
            for (String re : res) {
                System.out.println("resource = " + re);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        PathwayCommonsSeparated.printNetworkSizes();
    }

    private static void printNetworkSizes() {
        Graph graph = PathwayCommonsSeparated.getGraph(new HashSet<String>(Arrays.asList("reactome")), SIFEnum.values());
        graph.printStats();
        graph = PathwayCommonsSeparated.getGraph(new HashSet<String>(Arrays.asList("humancyc")), SIFEnum.values());
        graph.printStats();
    }
}

