/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import org.cbio.causality.util.FactorialSolver;

public class Binomial {
    public static double getPval(int count1, int count2) {
        int i;
        int heads = count1;
        int tosses = count1 + count2;
        if (heads * 2 >= tosses - 1 && heads * 2 <= tosses + 1) {
            return 1.0;
        }
        if ((double)heads > (double)tosses / 2.0) {
            heads = tosses - heads;
        }
        double pval = 0.0;
        ArrayList<Integer> twos = new ArrayList<Integer>();
        for (i = 0; i < tosses; ++i) {
            twos.add(2);
        }
        for (i = 0; i <= heads; ++i) {
            ArrayList<Integer> nom = new ArrayList<Integer>();
            nom.add(tosses);
            ArrayList<Integer> denom = new ArrayList<Integer>(twos);
            denom.add(i);
            denom.add(tosses - i);
            pval += FactorialSolver.solve(nom, denom);
        }
        return pval *= 2.0;
    }

    public static void main(String[] args) {
        int k1 = 9;
        int k2 = 1;
        double pval = Binomial.getPval(k1, k2);
        System.out.println("pval = " + pval);
        System.out.println("simu = " + Binomial.simulate(k1, k1 + k2));
    }

    public static double simulate(int heads, int tosses) {
        double mid = (double)tosses / 2.0;
        if ((double)heads > mid) {
            heads = tosses - heads;
        }
        int count = 0;
        int trials = 10000;
        for (int i = 0; i < trials; ++i) {
            int h = Binomial.generateRand(tosses);
            if ((double)h > mid) {
                h = tosses - h;
            }
            if (h > heads) continue;
            ++count;
        }
        return (double)count / (double)trials;
    }

    public static int generateRand(int tosses) {
        int h = 0;
        for (int j = 0; j < tosses; ++j) {
            if (!(Math.random() < 0.5)) continue;
            ++h;
        }
        return h;
    }
}

