/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class FileUtil {
    public static ZipEntry findEntryContainingNameInZIPFile(String zipFileName, String partOfEntryName) {
        return FileUtil.findEntryContainingNameInZIPFile(zipFileName, partOfEntryName, null);
    }

    public static ZipEntry findEntryContainingNameInZIPFile(String zipFileName, String partOfEntryName, String tabooPartOfEntryName) {
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String fileName;
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || !(fileName = zipEntry.getName()).contains(partOfEntryName) || tabooPartOfEntryName != null && fileName.contains(tabooPartOfEntryName)) continue;
                return zipEntry;
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return null;
    }

    public static boolean extractEntryContainingNameInTARGZFile(String targzFileName, String partOfEntryName, String extractedName) {
        try {
            TarArchiveEntry entry;
            TarArchiveInputStream is = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(targzFileName)));
            while ((entry = is.getNextTarEntry()) != null) {
                int len;
                if (entry.isDirectory() || !entry.getName().contains(partOfEntryName)) continue;
                byte[] btoRead = new byte[1024];
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(extractedName));
                while ((len = is.read(btoRead)) != -1) {
                    bout.write(btoRead, 0, len);
                }
                bout.close();
                is.close();
                return true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    public static boolean extractAllEntriesContainingNameInTARGZFile(String targzFileName, String partOfEntryName, String dir) {
        try {
            TarArchiveEntry entry;
            TarArchiveInputStream is = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(targzFileName)));
            boolean success = false;
            while ((entry = is.getNextTarEntry()) != null) {
                int len;
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (name.contains("/")) {
                    name = name.substring(name.lastIndexOf("/") + 1);
                }
                if (!name.contains(partOfEntryName)) continue;
                byte[] btoRead = new byte[1024];
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(dir + File.separator + name));
                while ((len = is.read(btoRead)) != -1) {
                    bout.write(btoRead, 0, len);
                }
                bout.close();
                success = true;
            }
            is.close();
            return success;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public static boolean extractEntryContainingNameInZipFile(String zipFileName, String partOfEntryName, String tabooPartOfEntryName, String extractedName) {
        try {
            ZipEntry ze;
            ZipEntry entry = FileUtil.findEntryContainingNameInZIPFile(zipFileName, partOfEntryName, tabooPartOfEntryName);
            FileOutputStream out = new FileOutputStream(extractedName);
            FileInputStream fin = new FileInputStream(zipFileName);
            BufferedInputStream bin = new BufferedInputStream(fin);
            ZipInputStream zin = new ZipInputStream(bin);
            while ((ze = zin.getNextEntry()) != null) {
                int len;
                if (!ze.getName().equals(entry.getName())) continue;
                byte[] buffer = new byte[8192];
                while ((len = zin.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                ((OutputStream)out).close();
                break;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    public static String getFileContent(String filename) {
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
            reader.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void printLines(String filename, String partialContent) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        int i = 0;
        String line = reader.readLine();
        while (line != null) {
            ++i;
            if (line.contains(partialContent)) {
                System.out.println("Line " + i + ": " + line);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public static void printLines(String filename, int fromLine, int toLine) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        int i = 0;
        String line = reader.readLine();
        while (line != null) {
            if (++i >= fromLine && i <= toLine) {
                System.out.println(line);
            }
            if (i > toLine) break;
            line = reader.readLine();
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) throws IOException {
        File sourceFile = new File(src);
        File destFile = new File(dest);
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                FileUtil.delete(file);
            }
        }
        dir.delete();
    }

    public static void main(String[] args) throws IOException {
        FileUtil.printLines("/home/babur/Projects/causalpath/src/main/resources/org/babur/causalpath/resource/mutation-stats.txt", 1, 1);
    }
}

