/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cbio.causality.util.Histogram2DPlot;
import org.cbio.causality.util.Waiter;

public class Histogram2D {
    private Map<Bin, Integer> bins;
    private double range;
    private int total;
    private String name;

    public Histogram2D(double range, String filename) {
        this(range);
        this.loadFromFile(filename);
        this.name = filename;
    }

    public Histogram2D(double range) {
        this.range = range;
        this.bins = new HashMap<Bin, Integer>();
        this.total = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getRange() {
        return this.range;
    }

    public int getMaxBinValue() {
        int max = 0;
        for (Integer i : this.bins.values()) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    public boolean isEmpty() {
        return this.bins.isEmpty();
    }

    public void count(double x, double y) {
        this.count(x, y, 1);
    }

    public void count(double x, double y, int add) {
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y)) {
            return;
        }
        Bin b = this.getBin(x, y);
        if (this.bins.containsKey(b)) {
            this.bins.put(b, this.bins.get(b) + add);
        } else {
            this.bins.put(b, add);
        }
        this.total += add;
    }

    private Bin getBin(double x, double y) {
        int i = (int)Math.floor(x / this.range + 0.5);
        int j = (int)Math.floor(y / this.range + 0.5);
        return new Bin(i, j);
    }

    public int getValue(double x, double y) {
        Bin b = this.getBin(x, y);
        if (this.bins.containsKey(b)) {
            return this.bins.get(b);
        }
        return 0;
    }

    public void add(Bin bin, int value) {
        if (this.bins.containsKey(bin)) {
            this.bins.put(bin, this.bins.get(bin) + value);
        } else {
            this.bins.put(bin, value);
        }
        this.total += value;
    }

    public void takeLog() {
        for (Bin bin : this.bins.keySet()) {
            int c = this.bins.get(bin);
            if (c <= 0) continue;
            this.bins.put(bin, (int)Math.round(Math.log(c)));
        }
    }

    public void add(Histogram2D h) {
        assert (this.range == h.range);
        for (Bin bin : h.bins.keySet()) {
            this.add(bin, h.bins.get(bin));
        }
    }

    public int[] getBinLimits() {
        if (this.bins.isEmpty()) {
            return new int[]{0, 0, 0, 0};
        }
        Bin b = this.bins.keySet().iterator().next();
        int maxx = b.x;
        int minx = b.x;
        int maxy = b.y;
        int miny = b.y;
        for (Bin bin : this.bins.keySet()) {
            if (bin.x > maxx) {
                maxx = bin.x;
            }
            if (bin.x < minx) {
                minx = bin.x;
            }
            if (bin.y > maxy) {
                maxy = bin.y;
            }
            if (bin.y >= miny) continue;
            miny = bin.y;
        }
        return new int[]{minx, maxx, miny, maxy};
    }

    public double[] getRealLimits() {
        int[] bl = this.getBinLimits();
        return new double[]{(double)bl[0] * this.range, (double)bl[1] * this.range, (double)bl[2] * this.range, (double)bl[3] * this.range};
    }

    public List<double[]> getOccupiedPoints() {
        ArrayList<double[]> points = new ArrayList<double[]>(this.bins.size());
        for (Bin bin : this.bins.keySet()) {
            points.add(new double[]{(double)bin.x * this.range, (double)bin.y * this.range});
        }
        return points;
    }

    public void writeWithWriter(Writer out, boolean withEmptyBins) {
        try {
            int[] limit = this.getBinLimits();
            for (int i = limit[0]; i < limit[1]; ++i) {
                double x = (double)i * this.range;
                for (int j = limit[2]; j < limit[3]; ++j) {
                    double y = (double)j * this.range;
                    Bin b = new Bin(i, j);
                    if (this.bins.containsKey(b)) {
                        out.write(x + "\t" + y + "\t" + this.bins.get(b) + "\n");
                        continue;
                    }
                    if (!withEmptyBins) continue;
                    out.write(x + "\t" + y + "\t0\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToFile(String filename, boolean withEmptyBins) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            this.writeWithWriter(writer, withEmptyBins);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadFromFile(String filename) {
        try {
            String line;
            this.bins.clear();
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                String[] terms = line.split("\t");
                if (terms.length != 3) continue;
                this.count(Double.parseDouble(terms[0]), Double.parseDouble(terms[1]), Integer.parseInt(terms[2]));
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void plot() {
        this.plot(true);
    }

    public void plot(boolean modal) {
        Histogram2DPlot p = new Histogram2DPlot(this);
        p.setVisible(true);
        if (modal) {
            p.setLocation(new Point(p.getLocation().x + p.getWidth(), p.getLocation().y));
            do {
                Waiter.pause(1000L);
            } while (p.isVisible());
        }
    }

    public static Histogram2D filterResults(Histogram2D hsignal, Histogram2D herror, double err_reduct_fact, double pval) {
        Histogram2D hfiltered = new Histogram2D(hsignal.range);
        for (Bin bin : hsignal.bins.keySet()) {
            double err_ratio;
            if (hsignal.bins.get(bin) <= 0 || herror.bins.containsKey(bin) && (err_ratio = (double)herror.bins.get(bin).intValue() * err_reduct_fact / (double)hsignal.bins.get(bin).intValue()) > pval) continue;
            hfiltered.add(bin, hsignal.bins.get(bin));
        }
        return hfiltered;
    }

    private class Bin {
        int x;
        int y;

        private Bin(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bin) {
                Bin b = (Bin)obj;
                return b.x == this.x && b.y == this.y;
            }
            return false;
        }

        public int hashCode() {
            return this.x + this.y;
        }
    }
}

