/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cbio.causality.util.Histogram2D;

public class Histogram2DPlot
extends JFrame
implements MouseListener,
MouseMotionListener {
    protected int binsPerTick = 10;
    protected double tickLength = 0.01;
    protected boolean preferGridToTick = true;
    protected int lightestColorNum = 200;
    protected int darkestColorNum = 0;
    protected int darkestValue = 3;
    protected JSlider darkestValSlider;
    protected JLabel darkestValLabel;
    protected JLabel totalValLabel;
    protected Color bgColor = Color.WHITE;
    protected Color axisColor = Color.BLACK;
    protected Color tickColor = Color.LIGHT_GRAY;
    protected Histogram2D histo;
    protected Histogram2D subset;
    protected double width_ratio;
    protected double height_ratio;
    protected double xmax;
    protected double xmin;
    protected double ymax;
    protected double ymin;
    protected List<double[]> points;
    protected List<double[]> lines;
    protected Color pointsColor = Color.RED;
    protected Color linesColor = Color.GREEN;
    protected double pointRadius = 0.003;
    private int x;
    private int y;
    public static final double ZOOM_STEP = 0.1;

    public Histogram2DPlot(Histogram2D histo) {
        this(histo, null);
    }

    public Histogram2DPlot(Histogram2D histo, Histogram2D subset) {
        this.setDefaultCloseOperation(2);
        this.setTitle("Density ModPrint");
        this.setSize(600, 700);
        this.setLayout(new BorderLayout());
        GraphPanel gp = new GraphPanel();
        this.getContentPane().add((Component)gp, "Center");
        gp.addMouseListener(this);
        gp.addMouseMotionListener(this);
        this.initControlsPanel();
        this.loadHisto(histo);
        if (subset != null) {
            this.loadSubset(subset);
        }
    }

    protected void loadHisto(Histogram2D histo) {
        this.histo = histo;
        if (histo.getName() != null) {
            String title = this.getTitle();
            if (title.contains(" - ")) {
                title = title.substring(0, title.indexOf(" - "));
            }
            this.setTitle(title + " - " + histo.getName());
        }
        double[] limits = histo.getRealLimits();
        double r = histo.getRange();
        double l = r * 10.0;
        this.xmin = Math.min(limits[0] - r, -l);
        this.xmax = Math.max(limits[1] + r, l);
        this.ymin = Math.min(limits[2] - r, -l);
        this.ymax = Math.max(limits[3] + r, l);
        int maxval = histo.getMaxBinValue();
        this.darkestValSlider.setMaximum(maxval);
        this.darkestValue = maxval;
        this.darkestValLabel.setText("" + this.darkestValue);
        this.darkestValSlider.setValue(this.darkestValue);
        this.totalValLabel.setText("Total: " + histo.getTotal());
    }

    protected void loadSubset(Histogram2D subset) {
        assert (this.histo != null);
        assert (this.histo.getRange() == subset.getRange());
        this.subset = subset;
        this.totalValLabel.setText(this.totalValLabel.getText() + " - " + subset.getTotal());
    }

    private void initControlsPanel() {
        JPanel cPanel = new JPanel();
        this.darkestValSlider = new JSlider(0, 1, this.darkestValue, this.darkestValue);
        this.darkestValLabel = new JLabel("" + this.darkestValue);
        this.totalValLabel = new JLabel("Total: 1000");
        this.darkestValSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Histogram2DPlot.this.darkestValue != Histogram2DPlot.this.darkestValSlider.getValue()) {
                    Histogram2DPlot.this.darkestValue = Histogram2DPlot.this.darkestValSlider.getValue();
                    Histogram2DPlot.this.darkestValLabel.setText("" + Histogram2DPlot.this.darkestValue);
                    Histogram2DPlot.this.repaint();
                }
            }
        });
        JButton zoomInButton = new JButton("+");
        zoomInButton.setSize(20, 20);
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double w = Histogram2DPlot.this.xmax - Histogram2DPlot.this.xmin;
                Histogram2DPlot.this.xmax -= w * 0.1;
                Histogram2DPlot.this.xmin += w * 0.1;
                double h = Histogram2DPlot.this.ymax - Histogram2DPlot.this.ymin;
                Histogram2DPlot.this.ymax -= h * 0.1;
                Histogram2DPlot.this.ymin += h * 0.1;
                Histogram2DPlot.this.repaint();
            }
        });
        JButton zoomOutButton = new JButton("-");
        zoomOutButton.setSize(20, 20);
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double w = Histogram2DPlot.this.xmax - Histogram2DPlot.this.xmin;
                Histogram2DPlot.this.xmax += w * 0.1;
                Histogram2DPlot.this.xmin -= w * 0.1;
                double h = Histogram2DPlot.this.ymax - Histogram2DPlot.this.ymin;
                Histogram2DPlot.this.ymax += h * 0.1;
                Histogram2DPlot.this.ymin -= h * 0.1;
                Histogram2DPlot.this.repaint();
            }
        });
        JLabel buf1 = new JLabel("    ");
        JLabel buf2 = new JLabel("    ");
        cPanel.add(this.darkestValSlider);
        cPanel.add(this.darkestValLabel);
        cPanel.add(buf1);
        cPanel.add(this.totalValLabel);
        cPanel.add(buf2);
        cPanel.add(zoomInButton);
        cPanel.add(zoomOutButton);
        this.getContentPane().add((Component)cPanel, "North");
    }

    private void ensurePointsInside() {
        if (this.points != null) {
            for (double[] p : this.points) {
                if (this.xmin > p[0]) {
                    this.xmin = p[0] - this.histo.getRange();
                } else if (this.xmax < p[0]) {
                    this.xmax = p[0] + this.histo.getRange();
                }
                if (this.ymin > p[1]) {
                    this.ymin = p[1] - this.histo.getRange();
                    continue;
                }
                if (!(this.ymax < p[1])) continue;
                this.ymax = p[1] + this.histo.getRange();
            }
        }
    }

    public double getXmax() {
        return this.xmax;
    }

    public void setXmax(double xmax) {
        this.xmax = xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public void setXmin(double xmin) {
        this.xmin = xmin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void setYmax(double ymax) {
        this.ymax = ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public void setYmin(double ymin) {
        this.ymin = ymin;
    }

    public int getBinsPerTick() {
        return this.binsPerTick;
    }

    public void setBinsPerTick(int binsPerTick) {
        this.binsPerTick = binsPerTick;
    }

    public double getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(double tickLength) {
        this.tickLength = tickLength;
    }

    public int getLightestColorNum() {
        return this.lightestColorNum;
    }

    public void setLightestColorNum(int lightestColorNum) {
        this.lightestColorNum = lightestColorNum;
    }

    public int getDarkestColorNum() {
        return this.darkestColorNum;
    }

    public void setDarkestColorNum(int darkestColorNum) {
        this.darkestColorNum = darkestColorNum;
    }

    public int getDarkestValue() {
        return this.darkestValue;
    }

    public void setDarkestValue(int darkestValue) {
        this.darkestValue = darkestValue;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color axisColor) {
        this.axisColor = axisColor;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor = tickColor;
    }

    public void setPoints(List<double[]> points) {
        for (double[] point : points) {
            if (!Double.isNaN(point[0]) && !Double.isNaN(point[1])) continue;
            throw new IllegalArgumentException("A point cannot be NaN on histogram plot.");
        }
        this.points = points;
        this.ensurePointsInside();
    }

    public void setLines(List<double[]> lines) {
        this.lines = lines;
    }

    public void setPointsColor(Color pointsColor) {
        if (pointsColor != null) {
            this.pointsColor = pointsColor;
        }
    }

    public void setLinesColor(Color linesColor) {
        if (linesColor != null) {
            this.linesColor = linesColor;
        }
    }

    private double rev_tw(int width) {
        return (double)width / this.width_ratio;
    }

    private double rev_th(int height) {
        return (double)height / this.height_ratio;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int dx = e.getX() - this.x;
        int dy = e.getY() - this.y;
        this.xmin -= this.rev_tw(dx);
        this.xmax -= this.rev_tw(dx);
        this.ymin += this.rev_th(dy);
        this.ymax += this.rev_th(dy);
        this.x = e.getX();
        this.y = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        Random r = new Random();
        Histogram2D h = new Histogram2D(0.1);
        Histogram2D s = new Histogram2D(0.1);
        for (int i = 0; i < 100000; ++i) {
            double x = r.nextGaussian();
            double y = r.nextGaussian();
            h.count(x, y);
            if (!(x + y + r.nextGaussian() > 0.0)) continue;
            s.count(x, y);
        }
        Histogram2DPlot p = new Histogram2DPlot(h, s);
        p.setVisible(true);
    }

    private class GraphPanel
    extends JPanel {
        private GraphPanel() {
        }

        @Override
        public void paint(Graphics g) {
            this.ensureRatio();
            if (g instanceof Graphics2D) {
                HashMap<RenderingHints.Key, Object> m = new HashMap<RenderingHints.Key, Object>();
                m.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHints(m);
            }
            Histogram2DPlot.this.width_ratio = (double)this.getWidth() / (Histogram2DPlot.this.xmax - Histogram2DPlot.this.xmin);
            Histogram2DPlot.this.height_ratio = (double)this.getHeight() / (Histogram2DPlot.this.ymax - Histogram2DPlot.this.ymin);
            this.drawBackground(g);
            this.drawBins(g);
            this.drawPoints(g);
            this.drawAxis(g);
            this.drawLines(g);
        }

        private void drawBins(Graphics g) {
            double r = Histogram2DPlot.this.histo.getRange();
            double h_r = r / 2.0;
            List<double[]> occupiedPoints = Histogram2DPlot.this.histo.getOccupiedPoints();
            for (double[] p : occupiedPoints) {
                Color c = Histogram2DPlot.this.subset == null ? this.getColor(Histogram2DPlot.this.histo.getValue(p[0], p[1])) : this.getColor(Histogram2DPlot.this.histo.getValue(p[0], p[1]), Histogram2DPlot.this.subset.getValue(p[0], p[1]));
                g.setColor(c);
                g.fillRect(this.tx(p[0] - h_r), this.ty(p[1] + h_r), this.tw(r), this.th(r));
            }
        }

        private Color getColor(int v) {
            if (v == 0) {
                return Color.WHITE;
            }
            if (v >= Histogram2DPlot.this.darkestValue) {
                return new Color(Histogram2DPlot.this.darkestColorNum, Histogram2DPlot.this.darkestColorNum, Histogram2DPlot.this.darkestColorNum);
            }
            int i = (int)((double)Histogram2DPlot.this.lightestColorNum - ((double)Histogram2DPlot.this.lightestColorNum - (double)Histogram2DPlot.this.darkestColorNum) / (double)(Histogram2DPlot.this.darkestValue - 1) * (double)(v - 1));
            return new Color(i, i, i);
        }

        private Color getColor(int v, int s) {
            assert (s <= v) : "Second histo must be a subset of the first";
            if (v == 0) {
                return Color.WHITE;
            }
            double expectedRat = (double)Histogram2DPlot.this.subset.getTotal() / (double)Histogram2DPlot.this.histo.getTotal();
            double observedRat = (double)s / (double)v;
            int g = v >= Histogram2DPlot.this.darkestValue ? Histogram2DPlot.this.darkestColorNum : (int)((double)Histogram2DPlot.this.lightestColorNum - ((double)Histogram2DPlot.this.lightestColorNum - (double)Histogram2DPlot.this.darkestColorNum) / (double)(Histogram2DPlot.this.darkestValue - 1) * (double)(v - 1));
            int r = g;
            int b = g;
            if (observedRat > expectedRat) {
                double rat = (observedRat - expectedRat) / (1.0 - expectedRat);
                r = (int)((double)(255 - g) * rat + (double)g);
            } else {
                double rat = (expectedRat - observedRat) / expectedRat;
                b = (int)((double)(255 - g) * rat + (double)g);
            }
            return new Color(r, g, b);
        }

        private void drawBackground(Graphics g) {
            super.paint(g);
            g.setColor(Histogram2DPlot.this.bgColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }

        private void drawAxis(Graphics g) {
            this.drawTicksOrGrid(g);
            g.setColor(Histogram2DPlot.this.axisColor);
            g.drawLine(this.tx(0.0), this.ty(Histogram2DPlot.this.ymax), this.tx(0.0), this.ty(Histogram2DPlot.this.ymin));
            g.drawLine(this.tx(Histogram2DPlot.this.xmin), this.ty(0.0), this.tx(Histogram2DPlot.this.xmax), this.ty(0.0));
        }

        private void drawTicksOrGrid(Graphics g) {
            double d;
            g.setColor(Histogram2DPlot.this.tickColor);
            double range = Histogram2DPlot.this.histo.getRange();
            double tick_range = range * (double)Histogram2DPlot.this.binsPerTick;
            double min = Math.ceil(Histogram2DPlot.this.xmin / tick_range) * tick_range;
            double halfTick = Histogram2DPlot.this.tickLength / 2.0;
            for (d = min; d < Histogram2DPlot.this.xmax; d += tick_range) {
                d = this.fixAccuracy(d);
                if (Histogram2DPlot.this.preferGridToTick) {
                    g.drawLine(this.tx(d), this.ty(Histogram2DPlot.this.ymax), this.tx(d), this.ty(Histogram2DPlot.this.ymin));
                } else {
                    g.drawLine(this.tx(d), this.ty(halfTick), this.tx(d), this.ty(-halfTick));
                }
                g.drawString("" + d, this.tx(d + halfTick), this.ty(halfTick));
            }
            for (d = min = Math.ceil(Histogram2DPlot.this.ymin / tick_range) * tick_range; d < Histogram2DPlot.this.ymax; d += tick_range) {
                d = this.fixAccuracy(d);
                if (Histogram2DPlot.this.preferGridToTick) {
                    g.drawLine(this.tx(Histogram2DPlot.this.xmin), this.ty(d), this.tx(Histogram2DPlot.this.xmax), this.ty(d));
                } else {
                    g.drawLine(this.tx(-halfTick), this.ty(d), this.tx(halfTick), this.ty(d));
                }
                g.drawString("" + d, this.tx(halfTick), this.ty(d + halfTick));
            }
        }

        private double fixAccuracy(double d) {
            if (d == 0.0) {
                d = 0.0;
            }
            d *= 1000000.0;
            d = Math.round(d);
            return d /= 1000000.0;
        }

        private void drawLines(Graphics g) {
            if (Histogram2DPlot.this.lines != null) {
                g.setColor(Histogram2DPlot.this.linesColor);
                for (double[] param : Histogram2DPlot.this.lines) {
                    this.drawLine(g, param[0], param[1]);
                }
            }
        }

        private void drawPoints(Graphics g) {
            if (Histogram2DPlot.this.points != null) {
                g.setColor(Histogram2DPlot.this.pointsColor);
                for (double[] coor : Histogram2DPlot.this.points) {
                    this.drawPoint(g, coor[0], coor[1], Histogram2DPlot.this.pointRadius);
                }
            }
        }

        private void ensureRatio() {
            double widthG = Histogram2DPlot.this.xmax - Histogram2DPlot.this.xmin;
            double heightG = Histogram2DPlot.this.ymax - Histogram2DPlot.this.ymin;
            double ratioG = widthG / heightG;
            double eps = 1.0E-5;
            double ratioW = (double)this.getWidth() / (double)this.getHeight();
            if (ratioG + eps > ratioW && ratioG - eps < ratioW) {
                return;
            }
            if (ratioW > ratioG) {
                double idealWidth = heightG * ratioW;
                double dif = (idealWidth - widthG) / 2.0;
                Histogram2DPlot.this.xmax += dif;
                Histogram2DPlot.this.xmin -= dif;
            } else if (ratioW < ratioG) {
                double idealHeight = widthG / ratioW;
                double dif = (idealHeight - heightG) / 2.0;
                Histogram2DPlot.this.ymax += dif;
                Histogram2DPlot.this.ymin -= dif;
            }
        }

        private int tx(double v) {
            return (int)Math.round((v - Histogram2DPlot.this.xmin) * Histogram2DPlot.this.width_ratio);
        }

        private int ty(double v) {
            return (int)Math.round((Histogram2DPlot.this.ymax - v) * Histogram2DPlot.this.height_ratio);
        }

        private int tw(double width) {
            return (int)Math.ceil(width * Histogram2DPlot.this.width_ratio);
        }

        private int th(double height) {
            return (int)Math.ceil(height * Histogram2DPlot.this.height_ratio);
        }

        private void drawLine(Graphics g, double a, double b) {
            g.drawLine(this.tx(Histogram2DPlot.this.xmin), this.ty(Histogram2DPlot.this.xmin * a + b), this.tx(Histogram2DPlot.this.xmax), this.ty(Histogram2DPlot.this.xmax * a + b));
        }

        private void drawPoint(Graphics g, double x, double y, double radius) {
            g.fillOval(this.tx(x - radius), this.ty(y + radius), this.tw(radius * 2.0), this.th(radius * 2.0));
        }
    }
}

