/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math.MathException;
import org.apache.commons.math.stat.inference.TestUtils;
import org.cbio.causality.util.ArrayUtil;
import org.cbio.causality.util.ErrorFunction;
import org.cbio.causality.util.Histogram;
import org.cbio.causality.util.Summary;

public class StudentsT {
    public static final double SQRT2 = Math.sqrt(2.0);

    public static double getPValOfMeanDifference(double[] x0, double[] x1) {
        if (x0.length < 2 || x1.length < 2) {
            return Double.NaN;
        }
        try {
            return TestUtils.tTest(x0, x1);
        }
        catch (MathException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static double getPValOfMeanEqualTo(double[] x, double mean) {
        if (x.length < 2) {
            return Double.NaN;
        }
        try {
            return TestUtils.tTest(mean, x);
        }
        catch (MathException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static double getPValOfMeanDifference_OldAndWrong(double[] x0, double[] x1) {
        if (x0.length == 0 || x1.length == 0) {
            return 1.0;
        }
        double mean0 = Summary.mean(x0);
        double mean1 = Summary.mean(x1);
        double var0 = Summary.variance(x0);
        double var1 = Summary.variance(x1);
        if (Double.isNaN(mean0) || Double.isNaN(mean1)) {
            return 1.0;
        }
        double sd = StudentsT.calcSDForEqualVar(x0.length, x1.length, var0, var1);
        if (sd == 0.0) {
            return 1.0;
        }
        double v = Math.abs(mean0 - mean1) / (sd * SQRT2);
        return 1.0 - ErrorFunction.getSignif(v);
    }

    private static double calcSDForEqualVar(int n0, int n1, double var0, double var1) {
        double sd = var0 * (double)(n0 - 1) + var1 * (double)(n1 - 1);
        sd /= (double)(n0 + n1 - 2);
        sd = Math.sqrt(sd);
        return sd *= Math.sqrt(1.0 / (double)n0 + 1.0 / (double)n1);
    }

    private static double calcSDForUnequalVar(int n0, int n1, double var0, double var1) {
        double sd = var0 / (double)n0 + var1 / (double)n1;
        sd = Math.sqrt(sd);
        return sd;
    }

    public static void main(String[] args) {
        Histogram h = new Histogram(0.01);
        h.setBorderAtZero(true);
        for (int j = 0; j < 200000; ++j) {
            int i;
            ArrayList<Double> list1 = new ArrayList<Double>();
            ArrayList<Double> list2 = new ArrayList<Double>();
            Random rand = new Random();
            for (i = 0; i < 20; ++i) {
                list1.add(rand.nextGaussian());
            }
            for (i = 0; i < 5; ++i) {
                list2.add(rand.nextGaussian());
            }
            double[] vals1 = ArrayUtil.toArray(list1, 0.0);
            double[] vals2 = ArrayUtil.toArray(list2, 0.0);
            double p = StudentsT.getPValOfMeanDifference(vals1, vals2);
            h.count(p);
        }
        h.print();
    }

    public static double getPValOfMeanDifferenceBySimulation(double[] x0, double[] x1, int maxTrials, int maxHits) {
        int trial;
        double mean0 = Summary.mean(x0);
        double mean1 = Summary.mean(x1);
        double dif = Math.abs(mean0 - mean1);
        ArrayList<Double> nums = new ArrayList<Double>(x0.length + x1.length);
        for (double v : x0) {
            nums.add(v);
        }
        for (double v : x1) {
            nums.add(v);
        }
        int hit = 0;
        double[] xx0 = new double[x0.length];
        double[] xx1 = new double[x1.length];
        for (trial = 0; trial < maxTrials; ++trial) {
            Collections.shuffle(nums);
            double d = StudentsT.getDifOfMean(nums, xx0, xx1);
            if (d >= dif) {
                ++hit;
            }
            if (hit != maxHits) continue;
            ++trial;
            break;
        }
        return (double)hit / (double)trial;
    }

    private static double getDifOfMean(List<Double> nums, double[] xx0, double[] xx1) {
        int j;
        for (j = 0; j < xx0.length; ++j) {
            xx0[j] = nums.get(j);
        }
        for (j = 0; j < xx1.length; ++j) {
            xx1[j] = nums.get(xx0.length + j);
        }
        return Math.abs(Summary.mean(xx0) - Summary.mean(xx1));
    }
}

