/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cbio.causality.util.Histogram;

public class TermCounter {
    private Map<String, Item> termMap = new HashMap<String, Item>();
    private int samples = 0;

    public void addTerm(String term) {
        if (!this.termMap.containsKey(term)) {
            this.termMap.put(term, new Item(term));
        }
        this.termMap.get(term).increment();
        ++this.samples;
    }

    public boolean contains(String term) {
        return this.termMap.containsKey(term);
    }

    public Map<String, Integer> getTermCounts() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String key : this.termMap.keySet()) {
            Item item = this.termMap.get(key);
            map.put(item.term, item.count);
        }
        return map;
    }

    public List<String> getMostFrequentTerms(int minCount) {
        ArrayList<String> terms = new ArrayList<String>();
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : this.termMap.values()) {
            if (item.count < minCount) continue;
            items.add(item);
        }
        Collections.sort(items);
        for (Item item : items) {
            terms.add(item.term);
        }
        return terms;
    }

    public String getMostFrequentTerm() {
        ArrayList<Item> items = new ArrayList<Item>(this.termMap.values());
        Collections.sort(items);
        if (items.isEmpty()) {
            return null;
        }
        return ((Item)items.get((int)0)).term;
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int minCnt) {
        String s = "Total terms = " + this.termMap.size() + ", samples = " + this.samples + "\n";
        Object[] items = this.termMap.values().toArray(new Item[this.termMap.values().size()]);
        Arrays.sort(items);
        for (Object item : items) {
            if (((Item)item).count < minCnt) break;
            s = s + ((Item)item).toString() + "\n";
        }
        return s;
    }

    public void printFreqDistr() {
        Histogram h = new Histogram(1.0);
        for (Item item : this.termMap.values()) {
            h.count(item.count.intValue());
        }
        h.printDensity();
    }

    public void print() {
        System.out.println(this);
    }

    public void print(int minCnt) {
        System.out.println(this.toString(minCnt));
    }

    private class Item
    implements Comparable {
        String term;
        Integer count;

        private Item(String term) {
            this.term = term;
            this.count = 0;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Item)) {
                return 0;
            }
            Item other = (Item)o;
            return other.count.compareTo(this.count);
        }

        void increment() {
            this.count = this.count + 1;
        }

        public String toString() {
            return this.count + "\t" + this.term;
        }
    }
}

