/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util.trendline;

import java.util.Arrays;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.stat.regression.OLSMultipleLinearRegression;
import org.cbio.causality.util.trendline.TrendLine;

public abstract class OLSTrendLine
implements TrendLine {
    RealMatrix coef = null;

    protected abstract double[] xVector(double var1);

    protected abstract boolean logY();

    @Override
    public void setValues(double[] y, double[] x) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The numbers of y and x values must be equal (%d != %d)", y.length, x.length));
        }
        double[][] xData = new double[x.length][];
        for (i = 0; i < x.length; ++i) {
            xData[i] = this.xVector(x[i]);
        }
        if (this.logY()) {
            y = Arrays.copyOf(y, y.length);
            for (i = 0; i < x.length; ++i) {
                y[i] = Math.log(y[i]);
            }
        }
        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
        ols.setNoIntercept(true);
        ols.newSampleData(y, xData);
        this.coef = MatrixUtils.createColumnRealMatrix(ols.estimateRegressionParameters());
    }

    @Override
    public double predict(double x) {
        double yhat = this.coef.preMultiply(this.xVector(x))[0];
        if (this.logY()) {
            yhat = Math.exp(yhat);
        }
        return yhat;
    }
}

