/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteTemplateEntry;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class TemplateTransferDragSourceListener
extends AbstractTransferDragSourceListener {
    public TemplateTransferDragSourceListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    public TemplateTransferDragSourceListener(EditPartViewer viewer) {
        super(viewer, TemplateTransfer.getInstance());
    }

    public void dragFinished(DragSourceEvent event) {
        TemplateTransfer.getInstance().setTemplate(null);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getTemplate();
    }

    public void dragStart(DragSourceEvent event) {
        Object template = this.getTemplate();
        if (template == null) {
            event.doit = false;
        }
        TemplateTransfer.getInstance().setTemplate(template);
    }

    protected Object getTemplate() {
        List selection = this.getViewer().getSelectedEditParts();
        if (selection.size() == 1) {
            EditPart editpart = (EditPart)this.getViewer().getSelectedEditParts().get(0);
            Object model = editpart.getModel();
            if (model instanceof PaletteTemplateEntry) {
                return ((PaletteTemplateEntry)model).getTemplate();
            }
            if (model instanceof CombinedTemplateCreationEntry) {
                return ((CombinedTemplateCreationEntry)model).getTemplate();
            }
        }
        return null;
    }
}

