/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteEditPart;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;

class DrawerAnimationController {
    private long startTime = System.currentTimeMillis();
    private long endTime = 0L;
    private long presentTime = 0L;
    private static final int NUM_OF_MILLISECONDS = 150;
    private boolean inProgress;
    private boolean recording;
    private List drawers = new ArrayList();
    private DrawerFigure[] animate;
    private PaletteViewerPreferences prefs;

    public DrawerAnimationController(PaletteViewerPreferences prefs) {
        this.prefs = prefs;
    }

    public void addDrawer(DrawerEditPart drawer) {
        this.drawers.add(drawer);
    }

    public void animate(DrawerEditPart drawer) {
        this.inProgress = true;
        if (drawer.getDrawerFigure().isExpanded()) {
            List categoriesToCollapse = this.getDrawersToCollapse(drawer);
            this.animate = new DrawerFigure[categoriesToCollapse.size() + 1];
            int count = 1;
            Iterator iter = categoriesToCollapse.iterator();
            while (iter.hasNext()) {
                DrawerEditPart drwr = (DrawerEditPart)iter.next();
                drwr.setExpanded(false);
                this.animate[count++] = drwr.getDrawerFigure();
            }
            this.animate[0] = drawer.getDrawerFigure();
        } else {
            this.animate = new DrawerFigure[]{drawer.getDrawerFigure()};
        }
        int i = 0;
        while (i < this.animate.length) {
            this.animate[i].revalidate();
            ++i;
        }
        this.recording = true;
        FigureUtilities.getRoot(this.animate[0]).validate();
        this.recording = false;
        i = 0;
        while (i < this.animate.length) {
            this.animate[i].setAnimating(true);
            ++i;
        }
        this.start();
        this.runAnimation();
        i = 0;
        while (i < this.animate.length) {
            this.animate[i].setAnimating(false);
            ++i;
        }
        this.animate[0].getUpdateManager().performUpdate();
        this.animate = null;
    }

    void runAnimation() {
        while (this.inProgress) {
            this.step();
        }
        this.step();
    }

    void step() {
        this.presentTime = System.currentTimeMillis();
        if (this.presentTime > this.endTime) {
            this.inProgress = false;
            return;
        }
        int i = 0;
        while (i < this.animate.length) {
            this.animate[i].revalidate();
            ++i;
        }
        this.animate[0].getUpdateManager().performUpdate();
    }

    public float getAnimationProgress() {
        if (this.presentTime > this.endTime) {
            return 1.0f;
        }
        long timePassed = this.presentTime - this.startTime;
        float progress = (float)timePassed / 150.0f;
        return progress;
    }

    public int getNumberOfOpenDrawers() {
        int count = 0;
        Iterator iter = this.drawers.iterator();
        while (iter.hasNext()) {
            DrawerEditPart part = (DrawerEditPart)iter.next();
            if (!part.isExpanded()) continue;
            ++count;
        }
        return count;
    }

    public boolean isAnimationInProgress() {
        return this.inProgress;
    }

    public void removeDrawer(DrawerEditPart drawer) {
        this.drawers.remove(drawer);
    }

    public void start() {
        this.inProgress = true;
        this.presentTime = this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + 150L;
    }

    protected List getDrawersToCollapse(DrawerEditPart drawer) {
        PaletteEditPart part;
        int autoCollapseMode = this.prefs.getAutoCollapseSetting();
        if (autoCollapseMode == 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PaletteEditPart> drawersToCollapse = new ArrayList<PaletteEditPart>();
        if (autoCollapseMode == 2) {
            Iterator iter = this.drawers.iterator();
            while (iter.hasNext()) {
                DrawerEditPart cat = (DrawerEditPart)iter.next();
                if (!cat.isExpanded() || cat == drawer) continue;
                drawersToCollapse.add(cat);
            }
            return drawersToCollapse;
        }
        ArrayList<PaletteEditPart> potentialDrawersToCollapse = new ArrayList<PaletteEditPart>();
        DrawerFigure catFigure = drawer.getDrawerFigure();
        int availableWidth = catFigure.getParent().getClientArea().width;
        int availableHeight = catFigure.getParent().getSize().height;
        int requiredHeight = 0;
        Iterator iter = drawer.getParent().getChildren().iterator();
        while (iter.hasNext()) {
            DrawerFigure figure;
            part = (PaletteEditPart)iter.next();
            IFigure fig = part.getFigure();
            int height = fig.getPreferredSize((int)availableWidth, (int)-1).height;
            requiredHeight += height;
            if (!(part instanceof DrawerEditPart) || !(figure = (DrawerFigure)fig).isExpanded() || figure.isPinnedOpen()) continue;
            potentialDrawersToCollapse.add(part);
        }
        int i = potentialDrawersToCollapse.size() - 1;
        while (i >= 0 && requiredHeight > availableHeight) {
            part = (DrawerEditPart)potentialDrawersToCollapse.get(i);
            if (part != drawer) {
                int expandedHeight = part.getFigure().getPreferredSize((int)availableWidth, (int)-1).height;
                ((DrawerEditPart)part).setExpanded(false);
                int collapsedHeight = part.getFigure().getPreferredSize((int)availableWidth, (int)-1).height;
                requiredHeight -= expandedHeight - collapsedHeight;
                drawersToCollapse.add(part);
            }
            --i;
        }
        return drawersToCollapse;
    }

    public boolean isRecording() {
        return this.recording;
    }
}

