/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    Control control;
    CoolBar parent;
    boolean ideal;
    int preferredWidth;
    int preferredHeight;
    int minimumWidth;
    int minimumHeight;
    int requestedWidth;
    Rectangle itemBounds = new Rectangle(0, 0, 0, 0);
    static final int MARGIN_WIDTH = 4;
    static final int GRABBER_WIDTH = 2;
    static final int MINIMUM_WIDTH = 10;
    private int CHEVRON_HORIZONTAL_TRIM = -1;
    private int CHEVRON_VERTICAL_TRIM = -1;
    private static final int CHEVRON_LEFT_MARGIN = 2;
    private static final int CHEVRON_IMAGE_WIDTH = 8;
    ToolBar chevron;
    boolean wrap;
    Image arrowImage = null;

    public CoolItem(CoolBar coolBar, int n) {
        super(coolBar, n);
        this.parent = coolBar;
        coolBar.createItem(this, coolBar.getItemCount());
        this.calculateChevronTrim();
    }

    public CoolItem(CoolBar coolBar, int n, int n2) {
        super(coolBar, n);
        this.parent = coolBar;
        coolBar.createItem(this, n2);
        this.calculateChevronTrim();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void calculateChevronTrim() {
        ToolBar toolBar = new ToolBar(this.parent, 0x800000);
        ToolItem toolItem = new ToolItem(toolBar, 8);
        Image image = new Image((Device)this.display, 1, 1);
        toolItem.setImage(image);
        Point point = toolBar.computeSize(-1, -1);
        point = this.parent.fixPoint(point.x, point.y);
        this.CHEVRON_HORIZONTAL_TRIM = point.x - 1;
        this.CHEVRON_VERTICAL_TRIM = point.y - 1;
        toolBar.dispose();
        toolItem.dispose();
        image.dispose();
    }

    public Point computeSize(int n, int n2) {
        this.checkWidget();
        int n3 = n;
        int n4 = n2;
        if (n == -1) {
            n3 = 32;
        }
        if (n2 == -1) {
            n4 = 32;
        }
        if ((this.parent.style & 0x200) != 0) {
            n4 += 10;
        } else {
            n3 += 10;
        }
        return new Point(n3, n4);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        if (this.chevron != null && !this.chevron.isDisposed()) {
            this.chevron.dispose();
        }
        this.chevron = null;
        if (this.arrowImage != null && !this.arrowImage.isDisposed()) {
            this.arrowImage.dispose();
        }
        this.arrowImage = null;
    }

    Image createArrowImage(int n, int n2) {
        Point point = this.parent.fixPoint(n, n2);
        n = point.x;
        n2 = point.y;
        Color color = this.parent.getForeground();
        Color color2 = this.display.getSystemColor(2);
        Color color3 = this.parent.getBackground();
        PaletteData paletteData = new PaletteData(new RGB[]{color.getRGB(), color3.getRGB(), color2.getRGB()});
        ImageData imageData = new ImageData(n, n2, 4, paletteData);
        imageData.transparentPixel = 1;
        Image image = new Image((Device)this.display, imageData);
        GC gC = new GC(image, this.parent.getStyle() & 0x4000000);
        gC.setBackground(color3);
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(color2);
        int n3 = 0;
        if ((this.parent.style & 0x200) != 0) {
            n3 = n - 8;
        }
        int n4 = n2 / 6;
        int n5 = 2;
        gC.drawLine(n3, n4, n3 + n5, n4 + n5);
        gC.drawLine(n3, n4 + 2 * n5, n3 + n5, n4 + n5);
        gC.drawLine(++n3, n4, n3 + n5, n4 + n5);
        gC.drawLine(n3, n4 + 2 * n5, n3 + n5, n4 + n5);
        gC.drawLine(n3 += 3, n4, n3 + n5, n4 + n5);
        gC.drawLine(n3, n4 + 2 * n5, n3 + n5, n4 + n5);
        gC.drawLine(++n3, n4, n3 + n5, n4 + n5);
        gC.drawLine(n3, n4 + 2 * n5, n3 + n5, n4 + n5);
        gC.dispose();
        return image;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.parent.fixRectangle(this.itemBounds.x, this.itemBounds.y, this.itemBounds.width, this.itemBounds.height);
    }

    Rectangle internalGetBounds() {
        return new Rectangle(this.itemBounds.x, this.itemBounds.y, this.itemBounds.width, this.itemBounds.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return this.parent.fixPoint(this.minimumWidth, this.minimumHeight);
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getPreferredSize() {
        this.checkWidget();
        return this.parent.fixPoint(this.preferredWidth, this.preferredHeight);
    }

    public Point getSize() {
        this.checkWidget();
        return this.parent.fixPoint(this.itemBounds.width, this.itemBounds.height);
    }

    int internalGetMinimumWidth() {
        int n = this.minimumWidth + 10;
        if ((this.style & 4) != 0 && n < this.preferredWidth) {
            n += 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
        }
        return n;
    }

    void onSelection(Event event) {
        Rectangle rectangle = this.chevron.getBounds();
        Event event2 = new Event();
        event2.detail = 4;
        if ((this.parent.style & 0x200) != 0) {
            event2.x = rectangle.x + rectangle.width;
            event2.y = rectangle.y;
        } else {
            event2.x = rectangle.x;
            event2.y = rectangle.y + rectangle.height;
        }
        this.postEvent(13, event2);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void setBounds(int n, int n2, int n3, int n4) {
        this.itemBounds.x = n;
        this.itemBounds.y = n2;
        this.itemBounds.width = n3;
        this.itemBounds.height = n4;
        if (this.control != null) {
            int n5 = n3 - 10;
            if ((this.style & 4) != 0 && n3 < this.preferredWidth) {
                n5 -= 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
            }
            this.control.setBounds(this.parent.fixRectangle(n + 10, n2, n5, n4));
        }
        this.updateChevron();
    }

    public void setControl(Control control2) {
        this.checkWidget();
        if (control2 != null) {
            if (control2.isDisposed()) {
                this.error(5);
            }
            if (control2.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control2;
        if (control2 != null) {
            int n = this.itemBounds.width - 10;
            if ((this.style & 4) != 0 && this.itemBounds.width < this.preferredWidth) {
                n -= 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
            }
            control2.setBounds(this.parent.fixRectangle(this.itemBounds.x + 10, this.itemBounds.y, n, this.itemBounds.height));
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        Point point = this.parent.fixPoint(n, n2);
        this.minimumWidth = point.x;
        this.minimumHeight = point.y;
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setPreferredSize(int n, int n2) {
        this.checkWidget();
        this.ideal = true;
        Point point = this.parent.fixPoint(n, n2);
        this.preferredWidth = Math.max(point.x, 10);
        this.preferredHeight = point.y;
    }

    public void setPreferredSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setPreferredSize(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        Point point = this.parent.fixPoint(n, n2);
        n = Math.max(point.x, this.minimumWidth + 10);
        n2 = point.y;
        if (!this.ideal) {
            this.preferredWidth = n;
            this.preferredHeight = n2;
        }
        this.itemBounds.width = this.requestedWidth = n;
        this.itemBounds.height = n2;
        if (this.control != null) {
            int n3 = n - 10;
            if ((this.style & 4) != 0 && n < this.preferredWidth) {
                n3 -= 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
            }
            this.control.setSize(this.parent.fixPoint(n3, n2));
        }
        this.parent.relayout();
        this.updateChevron();
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    void updateChevron() {
        if (this.control != null) {
            int n = this.itemBounds.width;
            if ((this.style & 4) != 0 && n < this.preferredWidth) {
                int n2;
                int n3;
                int n4;
                if (this.chevron == null) {
                    this.chevron = new ToolBar(this.parent, 0x880000);
                    ToolItem toolItem = new ToolItem(this.chevron, 8);
                    toolItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            CoolItem.this.onSelection(event);
                        }
                    });
                }
                int n5 = 0;
                if ((this.parent.style & 0x200) != 0) {
                    n4 = this.control.getSize().x;
                    if (this.arrowImage != null) {
                        n5 = this.arrowImage.getBounds().width;
                    }
                } else {
                    n4 = this.control.getSize().y;
                    if (this.arrowImage != null) {
                        n5 = this.arrowImage.getBounds().height;
                    }
                }
                if (n5 != (n3 = Math.max(1, (n2 = Math.min(n4, this.itemBounds.height)) - this.CHEVRON_VERTICAL_TRIM))) {
                    Image image = this.createArrowImage(8, n3);
                    this.chevron.getItem(0).setImage(image);
                    if (this.arrowImage != null) {
                        this.arrowImage.dispose();
                    }
                    this.arrowImage = image;
                }
                this.chevron.setBackground(this.parent.getBackground());
                this.chevron.setBounds(this.parent.fixRectangle(this.itemBounds.x + n - 2 - 8 - this.CHEVRON_HORIZONTAL_TRIM, this.itemBounds.y, 8 + this.CHEVRON_HORIZONTAL_TRIM, n2));
                this.chevron.setVisible(true);
            } else if (this.chevron != null) {
                this.chevron.setVisible(false);
            }
        }
    }
}

