/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlKind;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.GetThemeMetric(0, nArray);
        if (this.horizontalBar != null) {
            n4 += nArray[0];
        }
        if (this.verticalBar != null) {
            n3 += nArray[0];
        }
        Rect rect = this.inset();
        return new Rectangle(n -= rect.left, n2 -= rect.top, n3 += rect.left + rect.right, n4 += rect.top + rect.bottom);
    }

    ScrollBar createScrollBar(int n) {
        return new ScrollBar(this, n);
    }

    ScrollBar createStandardBar(int n) {
        int n2 = this.findStandardBar(n);
        if (n2 == 0) {
            return null;
        }
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.parent = this;
        scrollBar.style = n;
        scrollBar.display = this.display;
        scrollBar.handle = n2;
        scrollBar.register();
        scrollBar.hookEvents();
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    void destroyScrollBar(ScrollBar scrollBar) {
        this.setScrollBarVisible(scrollBar, false);
        scrollBar.destroyHandle();
    }

    int findStandardBar(int n) {
        int n2 = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
        short[] sArray = new short[1];
        OS.CountSubControls(n2, sArray);
        if (sArray[0] == 0) {
            return 0;
        }
        int n3 = 0;
        int[] nArray = new int[1];
        OS.GetThemeMetric(0, nArray);
        int[] nArray2 = new int[1];
        ControlKind controlKind = new ControlKind();
        int[] nArray3 = new int[1];
        int n4 = 0;
        while (n4 < sArray[0]) {
            OS.GetIndexedSubControl(n2, (short)(n4 + 1), nArray2);
            OS.GetControlKind(nArray2[0], controlKind);
            if (controlKind.kind == 1935827314) {
                nArray3[0] = 0;
                OS.GetControlProperty(nArray2[0], 1937208368, 1937208368, 4, null, nArray3);
                if (nArray3[0] == 0) {
                    Point point = this.getControlSize(nArray2[0]);
                    if ((n & 0x100) != 0) {
                        if (point.y == nArray[0]) {
                            n3 = nArray2[0];
                        }
                    } else if (point.x == nArray[0]) {
                        n3 = nArray2[0];
                    }
                }
            }
            ++n4;
        }
        return n3;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.state & 2) != 0 && this.hasBorder()) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(5, nArray);
            return nArray[0];
        }
        return 0;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        return new Rectangle(0, 0, rect.right - rect.left, rect.bottom - rect.top);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0 && this.scrolledHandle != 0) {
            int n = this.display.controlProc;
            int[] nArray = new int[]{1668183148, 4};
            int n2 = OS.GetControlEventTarget(this.scrolledHandle);
            OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.scrolledHandle, null);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    Rect inset() {
        if ((this.state & 2) != 0) {
            Rect rect = new Rect();
            int[] nArray = new int[1];
            if (this.drawFocusRing() && (this.style & 0x80000) == 0 && this.hooksKeys()) {
                OS.GetThemeMetric(7, nArray);
                rect.left = (short)(rect.left + nArray[0]);
                rect.top = (short)(rect.top + nArray[0]);
                rect.right = (short)(rect.right + nArray[0]);
                rect.bottom = (short)(rect.bottom + nArray[0]);
            }
            if (this.hasBorder()) {
                OS.GetThemeMetric(5, nArray);
                rect.left = (short)(rect.left + nArray[0]);
                rect.top = (short)(rect.top + nArray[0]);
                rect.right = (short)(rect.right + nArray[0]);
                rect.bottom = (short)(rect.bottom + nArray[0]);
            }
            return rect;
        }
        return EMPTY_RECT;
    }

    boolean isTrimHandle(int n) {
        if (this.horizontalBar != null && this.horizontalBar.handle == n) {
            return true;
        }
        if (this.verticalBar != null && this.verticalBar.handle == n) {
            return true;
        }
        return n == this.scrolledHandle;
    }

    int kEventMouseWheelMoved(int n, int n2, int n3) {
        Event event;
        int n4;
        int n5 = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int n6 = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int n7 = super.kEventMouseWheelMoved(n, n2, n3);
        boolean bl = false;
        if (this.verticalBar != null && (n4 = this.verticalBar.getSelection()) != n5) {
            event = new Event();
            event.detail = n4 < n5 ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
            bl = true;
        }
        if (this.horizontalBar != null && (n4 = this.horizontalBar.getSelection()) != n6) {
            event = new Event();
            event.detail = n4 < n5 ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
            bl = true;
        }
        if (bl) {
            this.redrawBackgroundImage();
        }
        return n7;
    }

    void redrawBackgroundImage() {
        Control control2;
        if (this.scrolledHandle == 0 && (control2 = this.findBackgroundControl()) != null && control2.backgroundImage != null) {
            this.redrawWidget(this.handle, false);
        }
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void releaseChildren(boolean bl) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl);
    }

    void resetVisibleRegion(int n) {
        if (this.verticalBar != null) {
            this.verticalBar.resetVisibleRegion(n);
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.resetVisibleRegion(n);
        }
        super.resetVisibleRegion(n);
    }

    void resizeClientArea() {
        boolean bl;
        if (this.scrolledHandle == 0) {
            return;
        }
        if ((this.state & 2) == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[1];
        OS.GetThemeMetric(0, nArray);
        boolean bl2 = this.horizontalBar != null && this.horizontalBar.getVisible();
        boolean bl3 = bl = this.verticalBar != null && this.verticalBar.getVisible();
        if (bl2) {
            n2 = nArray[0];
        }
        if (bl) {
            n = nArray[0];
        }
        CGRect cGRect = new CGRect();
        OS.HIViewGetBounds(this.scrolledHandle, cGRect);
        int n3 = (int)cGRect.width;
        int n4 = (int)cGRect.height;
        Rect rect = this.inset();
        n3 = Math.max(0, n3 - n - rect.left - rect.right);
        n4 = Math.max(0, n4 - n2 - rect.top - rect.bottom);
        this.setBounds(this.handle, rect.left, rect.top, n3, n4, true, true, false);
        if (bl2) {
            this.setBounds(this.horizontalBar.handle, rect.left, rect.top + n4, n3, n2, true, true, false);
        }
        if (bl) {
            this.setBounds(this.verticalBar.handle, rect.left + n3, rect.top, n, n4, true, true, false);
        }
    }

    boolean sendMouseWheel(short s, int n) {
        if ((this.state & 2) != 0) {
            ScrollBar scrollBar;
            ScrollBar scrollBar2 = scrollBar = s == 0 ? this.horizontalBar : this.verticalBar;
            if (scrollBar != null && scrollBar.getEnabled()) {
                scrollBar.setSelection(Math.max(0, scrollBar.getSelection() - scrollBar.getIncrement() * n));
                Event event = new Event();
                event.detail = n > 0 ? 0x1000005 : 0x1000006;
                scrollBar.sendEvent(13, event);
                return true;
            }
        }
        return false;
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, false);
        if ((n5 & 0x40) != 0 && bl3) {
            this.sendEvent(10);
        }
        if ((n5 & 0x80) != 0) {
            this.resizeClientArea();
            if (bl3) {
                this.sendEvent(11);
            }
        }
        return n5;
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        if (this.scrolledHandle == 0) {
            return false;
        }
        if ((this.state & 2) == 0) {
            return false;
        }
        this.resizeClientArea();
        this.setVisible(scrollBar.handle, bl);
        return true;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrolledHandle != 0) {
            OS.HIViewAddSubview(this.scrolledHandle, this.handle);
        }
    }

    int topHandle() {
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        return this.handle;
    }
}

