/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.CyclePartAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CycleEditorAction
extends CyclePartAction {
    public CycleEditorAction(IWorkbenchWindow window, boolean forward) {
        super(window, forward);
        this.updateState();
    }

    protected void setText() {
        if (this.forward) {
            this.setText(WorkbenchMessages.CycleEditorAction_next_text);
            this.setToolTipText(WorkbenchMessages.CycleEditorAction_next_toolTip);
            this.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.cycle_editor_forward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.nextEditor");
        } else {
            this.setText(WorkbenchMessages.CycleEditorAction_prev_text);
            this.setToolTipText(WorkbenchMessages.CycleEditorAction_prev_toolTip);
            this.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.cycle_editor_backward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.previousEditor");
        }
    }

    public void updateState() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(page.getSortedEditors().length >= 1);
    }

    protected void addItems(Table table, WorkbenchPage page) {
        IEditorReference[] refs = page.getSortedEditors();
        int i = refs.length - 1;
        while (i >= 0) {
            TableItem item = null;
            item = new TableItem(table, 0);
            if (refs[i].isDirty()) {
                item.setText("*" + refs[i].getTitle());
            } else {
                item.setText(refs[i].getTitle());
            }
            item.setImage(refs[i].getTitleImage());
            item.setData(refs[i]);
            --i;
        }
    }

    protected String getTableHeader() {
        return WorkbenchMessages.CycleEditorAction_header;
    }
}

