/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.framework;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.components.ComponentMessages;
import org.eclipse.ui.internal.components.ComponentUtil;
import org.eclipse.ui.internal.misc.StatusUtil;

public class ComponentException
extends Exception {
    private static final long serialVersionUID = 6009335074727417445L;
    private String componentName;
    private Throwable cause;

    public ComponentException(Object componentKey, Throwable reason) {
        this(componentKey, ComponentException.getMessage(componentKey, reason), reason);
    }

    public ComponentException(Object componentKey, String message, Throwable reason) {
        super(message);
        this.cause = ComponentUtil.getMostSpecificCause(reason);
        this.componentName = ComponentException.getShortName(componentKey);
    }

    private static String getShortName(Object key) {
        if (key instanceof Class) {
            return ComponentUtil.getSimpleClassName(((Class)key).getName());
        }
        return key.toString();
    }

    private static String getLongName(Object key) {
        if (key instanceof Class) {
            return ((Class)key).getName();
        }
        return key.toString();
    }

    private static String getMessage(Object key, Throwable reason) {
        String userString;
        String longName = ComponentException.getLongName(key);
        String shortName = ComponentException.getShortName(key);
        Throwable current = reason;
        while (current != null) {
            if (current instanceof ComponentException) {
                ComponentException ce = (ComponentException)current;
                if (shortName.equals(ce.getComponentName())) {
                    return ce.getLocalizedMessage();
                }
                return ComponentException.getMessageString(longName, (ComponentException)current);
            }
            Throwable cause = ComponentUtil.getCause(current);
            if (cause == current) break;
            current = cause;
        }
        reason = ComponentUtil.getCause(reason);
        if (reason != null && (userString = StatusUtil.getLocalizedMessage(reason)) != null) {
            return NLS.bind(ComponentMessages.ComponentException_unable_to_instantiate_because, longName, userString);
        }
        return NLS.bind(ComponentMessages.ComponentException_unable_to_instantiate, longName);
    }

    private static String getMessageString(String componentName, ComponentException e) {
        return NLS.bind(ComponentMessages.ComponentException_recursive_requires_string, new Object[]{componentName, e.getComponentName(), ComponentUtil.getMessage(e)});
    }

    public String getComponentName() {
        return this.componentName;
    }

    public IStatus getStatus() {
        return WorkbenchPlugin.getStatus(this.getMessage(), ComponentUtil.getCause(this));
    }

    public Throwable getCause() {
        return this.cause;
    }
}

