/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.List;
import org.cbio.causality.util.Summary;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.model.CompoundModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;

public class AlignSelectedAction
extends Action {
    ChisioMain main = null;
    ScrollingGraphicalViewer viewer;
    Direction dir;

    public AlignSelectedAction(ChisioMain main, Direction dir) {
        this(main, null, dir);
    }

    public AlignSelectedAction(ChisioMain main, ScrollingGraphicalViewer viewer, Direction dir) {
        super("Align Selected: " + dir.toString().substring(0, 1) + dir.toString().substring(1).toLowerCase());
        this.setToolTipText(this.getText());
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/layout-cose.gif"));
        this.main = main;
        this.viewer = viewer;
        this.dir = dir;
    }

    @Override
    public void run() {
        if (this.viewer == null) {
            this.viewer = this.main.getViewer();
        }
        if (this.viewer == null) {
            return;
        }
        List<GraphObject> selected = this.main.getSelectedModel();
        int newLoc = this.selectNewLoc(this.getLocs(selected));
        this.setNewLoc(selected, newLoc);
        this.adjustParents(selected);
        this.main.makeDirty();
        this.viewer = null;
    }

    private List<Integer> getLocs(List<GraphObject> selected) {
        ArrayList<Integer> locs = new ArrayList<Integer>();
        for (GraphObject go : selected) {
            int v;
            if (!(go instanceof NodeModel)) continue;
            NodeModel node = (NodeModel)go;
            switch (this.dir) {
                case TOP: {
                    v = node.getTopAbs();
                    break;
                }
                case BOTTOM: {
                    v = node.getBottomAbs();
                    break;
                }
                case LEFT: {
                    v = node.getLeftAbs();
                    break;
                }
                case RIGHT: {
                    v = node.getRightAbs();
                    break;
                }
                case X_CENTER: {
                    v = node.getCenterXAbs();
                    break;
                }
                case Y_CENTER: {
                    v = node.getCenterYAbs();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid direction: " + (Object)((Object)this.dir));
                }
            }
            locs.add(v);
        }
        return locs;
    }

    private void setNewLoc(List<GraphObject> selected, int newLoc) {
        block8: for (GraphObject go : selected) {
            if (!(go instanceof NodeModel)) continue;
            NodeModel node = (NodeModel)go;
            switch (this.dir) {
                case TOP: {
                    node.setTopAbs(newLoc);
                    continue block8;
                }
                case BOTTOM: {
                    node.setBottomAbs(newLoc);
                    continue block8;
                }
                case LEFT: {
                    node.setLeftAbs(newLoc);
                    continue block8;
                }
                case RIGHT: {
                    node.setRightAbs(newLoc);
                    continue block8;
                }
                case X_CENTER: {
                    node.setCenterXAbs(newLoc);
                    continue block8;
                }
                case Y_CENTER: {
                    node.setCenterYAbs(newLoc);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid direction: " + (Object)((Object)this.dir));
        }
    }

    private int selectNewLoc(List<Integer> locs) {
        switch (this.dir) {
            case TOP: 
            case LEFT: {
                return Summary.min(locs);
            }
            case BOTTOM: 
            case RIGHT: {
                return Summary.max(locs);
            }
            case X_CENTER: 
            case Y_CENTER: {
                return (int)Summary.mean(locs);
            }
        }
        throw new IllegalArgumentException("Invalid direction: " + (Object)((Object)this.dir));
    }

    private void adjustParents(List<GraphObject> selected) {
        for (GraphObject go : selected) {
            if (!(go instanceof NodeModel)) continue;
            NodeModel node = (NodeModel)go;
            this.adjustParent(node);
        }
    }

    private void adjustParent(NodeModel node) {
        CompoundModel parent = node.getParentModel();
        if (parent != null) {
            parent.calculateSizeUp();
            this.adjustParent(parent);
        }
    }

    public static enum Direction {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        X_CENTER,
        Y_CENTER;

    }
}

