/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cbio.causality.idmapping.HGNC;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.inspector.CBioPortalInspector;
import org.gvt.model.EntityAssociated;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.biopaxl3.BioPAXNode;

public class CBioPortalDataStatisticsAction
extends Action {
    protected ChisioMain main;

    public CBioPortalDataStatisticsAction(ChisioMain main) {
        super("Show cBio Portal Data Details");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbio_portal.png"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        this.execute();
    }

    public void execute() {
        Set<NodeModel> selectedNodes = this.getSelectedNodes();
        String symbol = null;
        for (NodeModel node : selectedNodes) {
            if (node instanceof EntityAssociated) {
                symbol = BioPAXNode.extractGeneSymbol(((EntityAssociated)((Object)node)).getEntity());
            } else if (node instanceof BasicSIFNode) {
                String text = node.getText();
                symbol = HGNC.getSymbol(text);
            }
            if (symbol == null) continue;
            CBioPortalInspector.getInstance(node, symbol + ": Data Details", this.main);
        }
    }

    protected Set<NodeModel> getSelectedNodes() {
        HashSet<NodeModel> selected = new HashSet<NodeModel>();
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
        while (selectedObjects.hasNext()) {
            Object o = ((EditPart)selectedObjects.next()).getModel();
            if (!(o instanceof NodeModel)) continue;
            selected.add((NodeModel)o);
        }
        return selected;
    }
}

