/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.command.DeleteCommand;
import org.gvt.command.DeleteConnectionCommand;
import org.gvt.editpart.ChsEdgeEditPart;
import org.gvt.editpart.ChsNodeEditPart;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;

public class DeleteAction
extends Action {
    private ChisioMain main;

    public DeleteAction(ChisioMain main) {
        super("Hide Selected");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/delete.gif"));
        this.main = main;
        this.setToolTipText(this.getText());
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer == null) {
            return;
        }
        Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
        while (selectedObjects.hasNext()) {
            EditPart childEditPart = (EditPart)selectedObjects.next();
            if (childEditPart instanceof ChsNodeEditPart) {
                NodeModel node = (NodeModel)childEditPart.getModel();
                node.resetClusters();
                DeleteCommand command = new DeleteCommand();
                command.setChild(node);
                EditPart parent = childEditPart.getParent();
                command.setParent((CompoundModel)parent.getModel());
                command.execute();
                continue;
            }
            if (!(childEditPart instanceof ChsEdgeEditPart)) continue;
            DeleteConnectionCommand command = new DeleteConnectionCommand();
            command.setConnectionModel(childEditPart.getModel());
            command.execute();
        }
    }
}

