/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.OpenPathwaysAction;
import org.gvt.model.BioPAXGraph;
import org.gvt.util.PathwayHolder;

public class DuplicatePathwayAction
extends Action {
    private ChisioMain main;

    public DuplicatePathwayAction(ChisioMain main) {
        super("Duplicate Pathway");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-create-duplicate.png"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        String last;
        BioPAXGraph original = this.main.getPathwayGraph();
        if (original == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "No BioPAX pathway.");
            return;
        }
        if (!original.isMechanistic()) {
            MessageDialog.openError(this.main.getShell(), "Not Supported!", "Duplication is supported only in mechanistic views.");
            return;
        }
        original.recordLayout();
        PathwayHolder p = original.getPathway();
        String name = p.getName();
        if (name.indexOf(" ") > 0 && (last = name.substring(name.lastIndexOf(" ") + 1)).indexOf("(") == 0 && last.indexOf(")") == last.length() - 1) {
            boolean isdigit = true;
            for (int i = 1; isdigit && i < last.length() - 1; ++i) {
                isdigit = Character.isDigit(last.charAt(i));
            }
            if (isdigit) {
                name = name.substring(0, name.lastIndexOf(" "));
            }
        }
        PathwayHolder newP = new PathwayHolder(this.main.getBioPAXModel(), name);
        new OpenPathwaysAction(this.main, newP.getName());
    }
}

