/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.CancerStudy;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.data.portal.GeneticProfile;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.gvt.ChisioMain;
import org.gvt.action.ColorWithExperimentAction;
import org.gvt.gui.FetchFromCBioPortalDialog;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.util.Conf;
import org.patika.mada.dataXML.Experiment;
import org.patika.mada.dataXML.ObjectFactory;
import org.patika.mada.dataXML.Reference;
import org.patika.mada.dataXML.RootExperimentData;
import org.patika.mada.dataXML.Row;
import org.patika.mada.dataXML.ValueTuple;
import org.patika.mada.util.AlterationData;
import org.patika.mada.util.ExperimentDataManager;

public class FetchFromCBioPortalAction
extends Action {
    ChisioMain main;
    String study;
    public static final String CURRENT_STUDY = "CURRENT_STUDY";

    public FetchFromCBioPortalAction(ChisioMain main) {
        this(main, null);
    }

    public FetchFromCBioPortalAction(ChisioMain main, String study) {
        super(study == null ? "Fetch from cBioPortal..." : "Update cBioPortal data");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbio_portal.png"));
        this.main = main;
        if (study != null) {
            this.study = study;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var17_21;
        RootExperimentData experimentData;
        String dataDesc;
        String fileNameSuggestion;
        String dataName;
        if (this.main.getBioPAXModel() == null && this.getBasicSIFGraphs() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "No BioPAX model loaded.");
            return;
        }
        if (!this.initPortalAccessor()) {
            return;
        }
        if (this.study == null) {
            FetchFromCBioPortalDialog dialog = new FetchFromCBioPortalDialog(this.main);
            dialog.open();
        } else {
            if (this.study.equals(CURRENT_STUDY) && ChisioMain.cBioPortalAccessor == null) {
                MessageDialog.openError(this.main.getShell(), "Error!", "There is no current cBioPortal study loaded.");
                return;
            }
            if (!this.study.equals(CURRENT_STUDY) && !this.prepareAccessorForStudy(this.study)) {
                return;
            }
        }
        CBioPortalAccessor acc = ChisioMain.cBioPortalAccessor;
        List<GeneticProfile> currentGeneticProfiles = acc.getCurrentGeneticProfiles();
        if (currentGeneticProfiles.isEmpty()) {
            return;
        }
        ArrayList<Object> geneNames = new ArrayList<Object>();
        HashMap<Object, String> geneNameToXrefStr = new HashMap<Object, String>();
        Model model = this.main.getBioPAXModel();
        if (model != null) {
            for (RelationshipXref xref2 : model.getObjects(RelationshipXref.class)) {
                Object geneName;
                if (xref2.getDb() == null || !xref2.getDb().equals("HGNC SYMBOL") || (geneName = HGNC.getSymbol(xref2.getId())) == null || geneNames.contains(geneName)) continue;
                geneNames.add(geneName);
                geneNameToXrefStr.put(geneName, xref2.getId());
            }
        }
        for (BasicSIFGraph bsgraph : this.getBasicSIFGraphs()) {
            if (bsgraph == null) continue;
            for (Object o : bsgraph.getNodes()) {
                NodeModel node = (NodeModel)o;
                String text = node.getText();
                String symbol = HGNC.getSymbol(text);
                if (symbol == null) continue;
                geneNames.add(symbol);
                geneNameToXrefStr.put(text, symbol);
            }
        }
        if (currentGeneticProfiles.size() > 1) {
            dataName = "multiple data types";
            fileNameSuggestion = acc.getCurrentCancerStudy().getStudyId() + "_multi.ced";
            dataDesc = "";
            for (GeneticProfile currentGeneticProfile : currentGeneticProfiles) {
                dataDesc = dataDesc + currentGeneticProfile.getName() + " | " + currentGeneticProfile.getDescription() + "\n";
            }
        } else {
            GeneticProfile geneticProfile = currentGeneticProfiles.iterator().next();
            dataName = geneticProfile.getName();
            fileNameSuggestion = geneticProfile.getId() + ".ced";
            dataDesc = geneticProfile.getDescription();
        }
        ObjectFactory expFactory = new ObjectFactory();
        CancerStudy cancerStudy = acc.getCurrentCancerStudy();
        CaseList caseList = acc.getCurrentCaseList();
        this.main.lockWithMessage("Loading " + dataName + "...");
        try {
            experimentData = expFactory.createRootExperimentData();
        }
        catch (JAXBException e) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Could not create experiment.");
            return;
        }
        String alterationDataType = "cBio Portal Alteration Data";
        experimentData.setExperimentType(alterationDataType);
        String experimentInfo = cancerStudy.getName() + " | " + caseList.getDescription() + " (" + caseList.getCases().length + " cases) \n" + dataName + "\n" + dataDesc;
        experimentData.setExperimentSetInfo(experimentInfo);
        int count = 0;
        for (String caseId : caseList.getCases()) {
            try {
                Experiment experiment = expFactory.createExperiment();
                experiment.setNo(count++);
                experiment.setExperimentName(caseId);
                experiment.setExperimentInfo("Cancer Study: " + cancerStudy.getName() + "\nCase: " + caseId);
                experimentData.getExperiment().add(experiment);
            }
            catch (JAXBException e) {
                MessageDialog.openError(this.main.getShell(), "Error!", "Could not create experiment.");
                return;
            }
        }
        for (String string : geneNames) {
            AlterationPack alterations = acc.getAlterations(string);
            if (alterations == null) continue;
            if (alterations.get(Alteration.ANY) == null) {
                alterations.complete(Alteration.ANY);
            }
            try {
                Row row = expFactory.createRow();
                Reference ref = expFactory.createReference();
                ref.setDb("HGNC SYMBOL");
                ref.setValue((String)geneNameToXrefStr.get(string));
                row.getRef().add(ref);
                count = 0;
                for (Change change : alterations.get(Alteration.ANY)) {
                    double expValue = change.isAbsent() || !change.isAltered() ? AlterationData.VALUES.NOT_ALTERED.toDouble() : AlterationData.VALUES.ALTERED.toDouble();
                    ValueTuple tuple = expFactory.createValueTuple();
                    tuple.setNo(count++);
                    tuple.setValue(expValue);
                    row.getValue().add(tuple);
                }
                experimentData.getRow().add(row);
            }
            catch (JAXBException e) {
                MessageDialog.openError(this.main.getShell(), "Error!", "Could not process experiment.");
                return;
            }
        }
        if (!Conf.getBoolean("CBIOPORTAL_USE_CACHE")) {
            acc.clearAlterationCache();
        }
        this.main.setExperimentData(experimentData, fileNameSuggestion);
        ExperimentDataManager dataManager = this.main.getExperimentDataManager(alterationDataType);
        dataManager.setData(experimentData);
        dataManager.getSecondExpIndices().clear();
        dataManager.getFirstExpIndices().clear();
        boolean bl = false;
        while (var17_21 < caseList.getCases().length) {
            dataManager.getFirstExpIndices().add((int)var17_21);
            ++var17_21;
        }
        dataManager.setAveraging(0);
        List<BioPAXGraph> list = this.main.getAllPathwayGraphs();
        for (BioPAXGraph graph : list) {
            dataManager.clearExperimentData(graph);
            dataManager.associateExperimentData(graph);
            if (graph.getLastAppliedColoring() == null) continue;
            graph.setLastAppliedColoring(null);
            new ColorWithExperimentAction(this.main, graph, dataManager.getType()).run();
        }
        BioPAXGraph currentGraph = this.main.getPathwayGraph();
        if (currentGraph != null && currentGraph.getLastAppliedColoring() == null) {
            new ColorWithExperimentAction(this.main, currentGraph, dataManager.getType()).run();
        }
        this.main.unlock();
    }

    private List<BasicSIFGraph> getBasicSIFGraphs() {
        ArrayList<BasicSIFGraph> list = new ArrayList<BasicSIFGraph>();
        for (CTabItem tab : this.main.getTabToViewerMap().keySet()) {
            CompoundModel root = (CompoundModel)this.main.getTabToViewerMap().get(tab).getContents().getModel();
            if (!(root instanceof BasicSIFGraph)) continue;
            list.add((BasicSIFGraph)root);
        }
        return list;
    }

    private boolean initPortalAccessor() {
        if (ChisioMain.cBioPortalAccessor == null) {
            try {
                CBioPortalAccessor.setPortalURL(Conf.get("CBIOPORTAL_URL"));
                ChisioMain.cBioPortalAccessor = new CBioPortalAccessor();
                CBioPortalAccessor.setCacheDir(Conf.getPortalCacheDir());
                return true;
            }
            catch (IOException e) {
                MessageDialog.openError(this.main.getShell(), "Error!", "Could not access to cBio Portal.\n" + e.toString());
                return false;
            }
        }
        return true;
    }

    private boolean prepareAccessorForStudy(String study) {
        CBioPortalAccessor acc = ChisioMain.cBioPortalAccessor;
        return acc.configureForStudy(study);
    }
}

