/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.command.RemoveCompoundCommand;
import org.gvt.editpart.ChsCompoundEditPart;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl2.Compartment;

public class HideCompartmentsAction
extends Action {
    CompoundModel root;
    ChisioMain main;

    public HideCompartmentsAction(ChisioMain main) {
        super("Hide Compartments");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/delete-comp.gif"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer == null) {
            return;
        }
        HashSet<ChsCompoundEditPart> set = new HashSet<ChsCompoundEditPart>();
        this.collectCompartments(viewer.getRootEditPart().getContents(), set);
        for (ChsCompoundEditPart compartment : set) {
            RemoveCompoundCommand command = new RemoveCompoundCommand();
            command.setCompound((CompoundModel)compartment.getModel());
            command.execute();
        }
    }

    protected void collectCompartments(EditPart ep, Set<ChsCompoundEditPart> compartments) {
        if (ep instanceof ChsCompoundEditPart && (ep.getModel() instanceof org.gvt.model.biopaxl3.Compartment || ep.getModel() instanceof Compartment)) {
            compartments.add((ChsCompoundEditPart)ep);
        }
        for (Object o : ep.getChildren()) {
            if (!(o instanceof EditPart)) continue;
            this.collectCompartments((EditPart)o, compartments);
        }
    }
}

