/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFEdge;
import org.gvt.model.basicsif.BasicSIFGroup;
import org.gvt.model.basicsif.BasicSIFNode;

public class HighlightSIFDifferenceAction
extends ChiBEAction {
    String filename;

    public HighlightSIFDifferenceAction(ChisioMain main) {
        super("Highlight SIF Difference ...", null, main);
        this.addFilterExtension("FILE_KEY", new String[]{"*.sif"});
        this.addFilterName("FILE_KEY", new String[]{"SIF File (*.sif)"});
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        if (this.filename == null) {
            this.filename = new FileChooser(this).choose("FILE_KEY");
        }
        if (this.filename == null) {
            return;
        }
        HashSet<String> edgeNames = new HashSet<String>();
        this.loadElements(this.filename, edgeNames);
        int highlightedEdges = this.highlightAbsentEdges(edgeNames);
        if (highlightedEdges == 0) {
            MessageDialog.openInformation(this.main.getShell(), "Information:", "There is nothing to highlight.");
        } else {
            MessageDialog.openInformation(this.main.getShell(), "Information:", highlightedEdges + " edges are highlighted.");
        }
        this.filename = null;
    }

    protected int highlightAbsentEdges(Set<String> names) {
        CompoundModel root = (CompoundModel)((ChsRootEditPart)this.main.getViewer().getRootEditPart().getChildren().get(0)).getModel();
        Iterator iter = root.getEdges().iterator();
        int highlighted = 0;
        while (iter.hasNext()) {
            EdgeModel em = (EdgeModel)iter.next();
            if (!(em instanceof BasicSIFEdge)) continue;
            BasicSIFEdge edge = (BasicSIFEdge)em;
            NodeModel source = edge.getSource();
            NodeModel target = edge.getTarget();
            if (source instanceof BasicSIFGroup) {
                for (Object o : ((BasicSIFGroup)source).getChildren()) {
                    BasicSIFNode s = (BasicSIFNode)o;
                    if (target instanceof BasicSIFGroup) {
                        for (Object oo : ((BasicSIFGroup)target).getChildren()) {
                            BasicSIFNode t = (BasicSIFNode)oo;
                            if (!this.needsHighlight(edge, s, t, names)) continue;
                            this.highlight(edge, s, t);
                            ++highlighted;
                        }
                        continue;
                    }
                    if (!this.needsHighlight(edge, s, target, names)) continue;
                    this.highlight(edge, s);
                    ++highlighted;
                }
                continue;
            }
            if (target instanceof BasicSIFGroup) {
                for (Object o : ((BasicSIFGroup)target).getChildren()) {
                    BasicSIFNode t = (BasicSIFNode)o;
                    if (!this.needsHighlight(edge, source, t, names)) continue;
                    this.highlight(edge, t);
                    ++highlighted;
                }
                continue;
            }
            if (!this.needsHighlight(edge, source, target, names)) continue;
            this.highlight(edge);
            ++highlighted;
        }
        return highlighted;
    }

    protected void loadElements(String filename, Set<String> edgeNames) {
        try {
            Scanner sc = new Scanner(new File(filename));
            while (sc.hasNextLine()) {
                String[] token = sc.nextLine().split("\t");
                if (token.length < 3) continue;
                edgeNames.add(token[0] + " " + token[1] + " " + token[2]);
            }
            sc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean needsHighlight(BasicSIFEdge edge, NodeModel source, NodeModel target, Set<String> exclude) {
        String key = source.getText() + " " + edge.getTag() + " " + target.getText();
        if (exclude.contains(key)) {
            return false;
        }
        return edge.isDirected() || !exclude.contains(key = target.getText() + " " + edge.getTag() + " " + source.getText());
    }

    private void highlight(GraphObject ... gos) {
        for (GraphObject go : gos) {
            go.setHighlightColor(ChisioMain.higlightColor);
            go.setHighlight(true);
        }
    }
}

