/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.ColorWithExperimentAction;
import org.gvt.action.FileChooser;
import org.gvt.util.Conf;
import org.patika.mada.dataXML.ChisioExperimentData;
import org.patika.mada.dataXML.Row;
import org.patika.mada.dataXML.impl.ReferenceImpl;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.util.XRef;

public class LoadExperimentDataAction
extends ChiBEAction {
    String filename;
    boolean local = true;

    public LoadExperimentDataAction(ChisioMain main, String filename) {
        this(main);
        this.filename = filename;
    }

    public LoadExperimentDataAction(ChisioMain main, URL fileURL) throws IOException {
        this(main);
        this.filename = fileURL.toString();
        this.local = false;
    }

    public LoadExperimentDataAction(ChisioMain main) {
        super("Load ChiBE Formatted Data ...", "icon/open-cbe-formatted.png", main);
        this.addFilterExtension("FILE_KEY", new String[]{"*.ced"});
        this.addFilterName("FILE_KEY", new String[]{"ChiBE Experiment Data (*.ced)"});
        this.addLastLocation("FILE_KEY", Conf.getExperimentsDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.filename == null) {
            this.filename = new FileChooser(this).choose("FILE_KEY");
        }
        if (this.filename != null && LoadExperimentDataAction.hasValidExtension(this.filename)) {
            try {
                this.main.lockWithMessage("Loading experiment data ...");
                JAXBContext jc = JAXBContext.newInstance("org.patika.mada.dataXML");
                Unmarshaller u = jc.createUnmarshaller();
                ChisioExperimentData data = this.local ? (ChisioExperimentData)u.unmarshal(new File(this.filename)) : (ChisioExperimentData)u.unmarshal(new URL(this.filename));
                if (this.referenceMatch(data)) {
                    this.main.setExperimentData(data, this.filename);
                    new ColorWithExperimentAction(this.main, null, data.getExperimentType()).run();
                } else {
                    MessageDialog.openWarning(null, "No data!", "There is no external reference matching between graph and data.\nPlease make sure your BioPAX model contains proper external references that matches the references in expression data annotation.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.main.unlock();
            }
        }
        this.filename = null;
    }

    public boolean referenceMatch(ChisioExperimentData data) {
        boolean isMatching = false;
        ArrayList<String> graphRef = new ArrayList<String>(XRef.getDBSet());
        Map<List<String>, String> referenceList = ExperimentDataConvertionWizard.getKnownReferenceSetsMap();
        HashSet<String> cedRef = new HashSet<String>();
        Row row = (Row)data.getRow().get(0);
        for (int i = 0; i < row.getRef().size(); ++i) {
            cedRef.add(((ReferenceImpl)row.getRef().get(i)).getDb());
        }
        for (String ref : graphRef) {
            String refTxt = null;
            for (List<String> strings : referenceList.keySet()) {
                if (!strings.contains(ref)) continue;
                refTxt = referenceList.get(strings);
                break;
            }
            if (!cedRef.contains(refTxt)) continue;
            isMatching = true;
            break;
        }
        return isMatching;
    }

    public static boolean hasValidExtension(String path) {
        return path.endsWith(".ced");
    }
}

