/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cbio.causality.data.portal.BroadAccessor;
import org.cbio.causality.util.Download;
import org.gvt.ChisioMain;
import org.gvt.action.FetchFromCBioPortalAction;
import org.gvt.action.LoadTCGASpecificSIFAction;
import org.gvt.action.QueryPCAction;
import org.gvt.action.QueryPCGetAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.util.Conf;
import org.patika.mada.graph.Node;

public class LoadTCGASpecificReactionsAction
extends LoadTCGASpecificSIFAction {
    private static final String DEFAULT_REACTION_2_GENE_FILE_NAME = "reaction2gene.txt";

    public LoadTCGASpecificReactionsAction(ChisioMain main) {
        super("Retrieve hot reactions ...", main);
    }

    @Override
    public void run() {
        if (!LoadTCGASpecificReactionsAction.okToRun(this.main)) {
            return;
        }
        this.study = LoadTCGASpecificReactionsAction.getCurrentStudy();
        assert (this.study != null);
        Set<String> mutsig = BroadAccessor.getMutsigGenes(this.study, 1.0, true);
        List<Set<String>> gistic = BroadAccessor.getGisticGeneSets(this.study, 1.0);
        BioPAXL3Graph graph = LoadTCGASpecificReactionsAction.getGraph(this.main);
        HashSet<String> current = new HashSet<String>();
        for (Node node : graph.getNodes()) {
            current.add(node.getName());
        }
        Set<Reaction> reactions = this.getReactions(current, mutsig, gistic);
        final HashMap hashMap = new HashMap();
        for (Reaction r : reactions) {
            if (!hashMap.containsKey(r.getKey())) {
                hashMap.put(r.getKey(), new HashSet());
            }
            ((Set)hashMap.get(r.getKey())).add(r);
        }
        for (String key : hashMap.keySet()) {
            double maxDensity = 0.0;
            for (Reaction r : (Set)hashMap.get(key)) {
                if (!(r.getDensity() > maxDensity)) continue;
                maxDensity = r.getDensity();
            }
            Iterator iter = ((Set)hashMap.get(key)).iterator();
            while (iter.hasNext()) {
                Reaction r;
                r = (Reaction)iter.next();
                if (!(r.getDensity() < maxDensity)) continue;
                iter.remove();
            }
        }
        ArrayList keys = new ArrayList(hashMap.keySet());
        Collections.sort(keys);
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                return new Integer(((Reaction)((Set)hashMap.get((Object)key2)).iterator().next()).hitCnt).compareTo(((Reaction)((Set)hashMap.get((Object)key1)).iterator().next()).hitCnt);
            }
        });
        ArrayList selected = new ArrayList();
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 400, "Hot reactions", "Plase select reaction to view", keys, selected, true, true, null);
        dialog.open();
        if (dialog.isCancelled() || selected.isEmpty()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        for (Object key : selected) {
            for (Reaction r : (Set)hashMap.get(key)) {
                ids.addAll(r.ids);
            }
        }
        String title = "";
        for (String key : selected) {
            title = title + " [" + key + "]";
        }
        title = title.trim();
        QueryPCGetAction qa = new QueryPCGetAction(this.main, false, QueryPCAction.QueryLocation.PC_MECH);
        qa.setIDs(ids);
        qa.setNewPathwayName(title);
        qa.run();
        FetchFromCBioPortalAction fa = new FetchFromCBioPortalAction(this.main, "CURRENT_STUDY");
        fa.run();
    }

    private Set<Reaction> getReactions(Set<String> current, Set<String> mutSig, List<Set<String>> gistic) {
        File rFile = new File(this.getReactionFileLocation());
        if (!rFile.exists()) {
            this.downloadReactionFile(rFile.getPath());
        }
        try {
            HashSet<Reaction> reactions = new HashSet<Reaction>();
            BufferedReader reader = new BufferedReader(new FileReader(rFile));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                Reaction r = new Reaction(token[0], Arrays.asList(token).subList(1, token.length), current);
                HashSet<Set<String>> memory = new HashSet<Set<String>>();
                for (String s : r.hit) {
                    if (mutSig.contains(s)) {
                        ++r.hitCnt;
                        continue;
                    }
                    for (Set<String> set : gistic) {
                        if (!set.contains(s) || memory.contains(set)) continue;
                        memory.add(set);
                        ++r.hitCnt;
                    }
                }
                if (r.hitCnt > 2) {
                    reactions.add(r);
                }
                line = reader.readLine();
            }
            reader.close();
            return reactions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getReactionFileLocation() {
        String s = Conf.get("REACTION_2_GENE_FILE");
        if (s.equals("DEFAULT")) {
            return Conf.getPortalCacheDir() + DEFAULT_REACTION_2_GENE_FILE_NAME;
        }
        return s;
    }

    private boolean downloadReactionFile(String saveLoc) {
        String url = Conf.get("REACTION_2_GENE_FILE_URL");
        return Download.downlaodTextFile(url, saveLoc);
    }

    class Reaction
    implements Comparable {
        String id;
        List<String> ids;
        List<String> genes;
        List<String> hit;
        int hitCnt;

        Reaction(String ids, List<String> genes, Set<String> current) {
            this.ids = Arrays.asList(ids.split(" "));
            this.id = this.ids.get(0);
            this.genes = genes;
            this.hit = new ArrayList<String>(genes);
            this.hit.retainAll(current);
            Collections.sort(this.hit);
            this.hitCnt = 0;
        }

        double getDensity() {
            return (double)this.hit.size() / (double)this.genes.size();
        }

        String getKey() {
            String k = this.hit.get(0);
            int i = 0;
            for (String s : this.hit) {
                if (i++ == 0) continue;
                k = k + " - " + s;
            }
            return k;
        }

        public int compareTo(Object o) {
            if (o instanceof Reaction) {
                Reaction r = (Reaction)o;
                return new Double(r.getDensity()).compareTo(this.getDensity());
            }
            return 0;
        }
    }
}

