/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.LimitType;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.AbstractLocalQueryAction;
import org.gvt.gui.CompartmentQueryParamWithEntitiesDialog;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.QueryOptionsPack;

public class LocalCompartmentQueryAction
extends AbstractLocalQueryAction {
    ChisioMain main;
    QueryOptionsPack options;

    public LocalCompartmentQueryAction(ChisioMain main) {
        super(main, "Compartment ...");
        this.setToolTipText(this.getText());
        this.options = new QueryOptionsPack();
        this.main = main;
    }

    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        CompartmentQueryParamWithEntitiesDialog dialog = new CompartmentQueryParamWithEntitiesDialog(this.main);
        this.options = dialog.open(this.options);
        if (this.options.isCancel()) {
            return;
        }
        this.options.setCancel(true);
        HashSet<String> source = new HashSet<String>(dialog.getSourceAddedCompartments());
        HashSet<String> target = new HashSet<String>(dialog.getTargetAddedCompartments());
        Set<BioPAXElement> result = QueryExecuter.runPathsFromTo(BioPAXUtil.getElementsAtLocations(this.main.getBioPAXModel(), source), BioPAXUtil.getElementsAtLocations(this.main.getBioPAXModel(), target), this.main.getBioPAXModel(), this.options.getLimitType() ? LimitType.NORMAL : LimitType.SHORTEST_PLUS_K, this.options.getLengthLimit(), new Filter[0]);
        this.viewAndHighlightResult(result, this.options.isCurrentView(), "Query Result");
    }
}

